/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.AsconBaseEngine;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class AsconAEAD128
extends AsconBaseEngine {
    public AsconAEAD128() {
        this.CRYPTO_KEYBYTES = 16;
        this.CRYPTO_ABYTES = 16;
        this.ASCON_AEAD_RATE = 16;
        this.ASCON_IV = 17594342703105L;
        this.algorithmName = "Ascon-AEAD128";
        this.nr = 8;
        this.m_bufferSizeDecrypt = this.ASCON_AEAD_RATE + this.CRYPTO_ABYTES;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
        this.dsep = Long.MIN_VALUE;
    }

    protected long pad(int n) {
        return 1L << (n << 3);
    }

    protected long loadBytes(byte[] byArray, int n) {
        return Pack.littleEndianToLong(byArray, n);
    }

    protected void setBytes(long l, byte[] byArray, int n) {
        Pack.longToLittleEndian(l, byArray, n);
    }

    protected void ascon_aeadinit() {
        this.x0 = this.ASCON_IV;
        this.x1 = this.K0;
        this.x2 = this.K1;
        this.x3 = this.N0;
        this.x4 = this.N1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
    }

    protected void processFinalAadBlock() {
        if (this.m_bufPos >= 8) {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0);
            this.x1 ^= Pack.littleEndianToLong(this.m_buf, 8) ^ this.pad(this.m_bufPos);
        } else {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0) ^ this.pad(this.m_bufPos);
        }
    }

    protected void processFinalDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n >= 8) {
            long l = Pack.littleEndianToLong(byArray, 0);
            long l2 = Pack.littleEndianToLong(byArray, 8, n -= 8);
            Pack.longToLittleEndian(this.x0 ^ l, byArray2, n2);
            Pack.longToLittleEndian(this.x1 ^ l2, byArray2, n2 + 8, n);
            this.x0 = l;
            this.x1 &= -(1L << (n << 3));
            this.x1 |= l2;
            this.x1 ^= this.pad(n);
        } else {
            if (n != 0) {
                long l = Pack.littleEndianToLong(byArray, 0, n);
                Pack.longToLittleEndian(this.x0 ^ l, byArray2, n2, n);
                this.x0 &= -(1L << (n << 3));
                this.x0 |= l;
            }
            this.x0 ^= this.pad(n);
        }
        this.finishData(DecFinal);
    }

    protected void processFinalEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (n >= 8) {
            this.x0 ^= Pack.littleEndianToLong(byArray, 0);
            this.x1 ^= Pack.littleEndianToLong(byArray, 8, n -= 8);
            Pack.longToLittleEndian(this.x0, byArray2, n2);
            Pack.longToLittleEndian(this.x1, byArray2, n2 + 8);
            this.x1 ^= this.pad(n);
        } else {
            if (n != 0) {
                this.x0 ^= Pack.littleEndianToLong(byArray, 0, n);
                Pack.longToLittleEndian(this.x0, byArray2, n2, n);
            }
            this.x0 ^= this.pad(n);
        }
        this.finishData(EncFinal);
    }

    private void finishData(AsconBaseEngine.State state) {
        this.x2 ^= this.K0;
        this.x3 ^= this.K1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
        this.m_state = state;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        byte[] byArray;
        KeyParameter keyParameter;
        Object object;
        if (cipherParameters instanceof AEADParameters) {
            object = (AEADParameters)cipherParameters;
            keyParameter = ((AEADParameters)object).getKey();
            byArray = ((AEADParameters)object).getNonce();
            this.initialAssociatedText = ((AEADParameters)object).getAssociatedText();
            int n = ((AEADParameters)object).getMacSize();
            if (n != this.CRYPTO_ABYTES * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n);
            }
        } else if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            keyParameter = (KeyParameter)((ParametersWithIV)object).getParameters();
            byArray = ((ParametersWithIV)object).getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Ascon");
        }
        if (keyParameter == null) {
            throw new IllegalArgumentException("Ascon Init parameters must include a key");
        }
        if (byArray == null || byArray.length != this.CRYPTO_ABYTES) {
            throw new IllegalArgumentException("Ascon-AEAD-128 requires exactly " + this.CRYPTO_ABYTES + " bytes of IV");
        }
        object = keyParameter.getKey();
        if (((Object)object).length != this.CRYPTO_KEYBYTES) {
            throw new IllegalArgumentException("Ascon-AEAD-128 key must be " + this.CRYPTO_KEYBYTES + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, cipherParameters, Utils.getPurpose(bl)));
        this.K0 = Pack.littleEndianToLong((byte[])object, 0);
        this.K1 = Pack.littleEndianToLong((byte[])object, 8);
        this.N0 = Pack.littleEndianToLong(byArray, 0);
        this.N1 = Pack.littleEndianToLong(byArray, 8);
        this.m_state = bl ? EncInit : DecInit;
        this.reset(true);
    }

    public String getAlgorithmVersion() {
        return "v1.3";
    }
}

