/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import org.bouncycastle.math.raw.Bits;
import org.bouncycastle.util.Integers;

public class Longs {
    public static final int BYTES = 8;
    public static final int SIZE = 64;
    private static final byte[] DEBRUIJN_TZ = new byte[]{63, 0, 1, 52, 2, 6, 53, 26, 3, 37, 40, 7, 33, 54, 47, 27, 61, 4, 38, 45, 43, 41, 21, 8, 23, 34, 58, 55, 48, 17, 28, 10, 62, 51, 5, 25, 36, 39, 32, 46, 60, 44, 42, 20, 22, 57, 16, 9, 50, 24, 35, 31, 59, 19, 56, 15, 49, 30, 18, 14, 29, 13, 12, 11};

    public static long highestOneBit(long l) {
        l |= l >> 1;
        l |= l >> 2;
        l |= l >> 4;
        l |= l >> 8;
        l |= l >> 16;
        l |= l >> 32;
        return l - (l >>> 1);
    }

    public static long lowestOneBit(long l) {
        return l & -l;
    }

    public static int numberOfLeadingZeros(long l) {
        int n = (int)(l >>> 32);
        int n2 = 0;
        if (n == 0) {
            n2 = 32;
            n = (int)l;
        }
        return n2 + Integers.numberOfLeadingZeros(n);
    }

    public static int numberOfTrailingZeros(long l) {
        byte by = DEBRUIJN_TZ[(int)((l & -l) * 315175865370177754L >>> 58)];
        long l2 = (l & 0xFFFFFFFFL | l >>> 32) - 1L >> 63;
        return by - (int)l2;
    }

    public static long reverse(long l) {
        l = Bits.bitPermuteStepSimple(l, 0x5555555555555555L, 1);
        l = Bits.bitPermuteStepSimple(l, 0x3333333333333333L, 2);
        l = Bits.bitPermuteStepSimple(l, 0xF0F0F0F0F0F0F0FL, 4);
        return Longs.reverseBytes(l);
    }

    public static long reverseBytes(long l) {
        return Longs.rotateLeft(l & 0xFF000000FF000000L, 8) | Longs.rotateLeft(l & 0xFF000000FF0000L, 24) | Longs.rotateLeft(l & 0xFF000000FF00L, 40) | Longs.rotateLeft(l & 0xFF000000FFL, 56);
    }

    public static long rotateLeft(long l, int n) {
        return l << n | l >>> -n;
    }

    public static long rotateRight(long l, int n) {
        return l >>> n | l << -n;
    }

    public static Long valueOf(long l) {
        return new Long(l);
    }

    public static void xorTo(int n, long[] lArray, int n2, long[] lArray2, int n3) {
        for (int i = 0; i < n; ++i) {
            int n4 = n3 + i;
            lArray2[n4] = lArray2[n4] ^ lArray[n2 + i];
        }
    }
}

