/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;
import org.bouncycastle.util.Pack;

class SLHDSAShakeEngine
extends SLHDSAEngine {
    private final Xof treeDigest = SHAKEDigest.newInstance(256);
    private final Xof maskDigest = SHAKEDigest.newInstance(256);

    public SLHDSAShakeEngine(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    @Override
    void init(byte[] byArray) {
    }

    @Override
    byte[] F(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        byte[] byArray4 = new byte[this.N];
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(aDRS.value, 0, aDRS.value.length);
        this.treeDigest.update(byArray3, 0, byArray3.length);
        this.treeDigest.doFinal(byArray4, 0, byArray4.length);
        return byArray4;
    }

    @Override
    byte[] H(byte[] byArray, ADRS aDRS, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[this.N];
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(aDRS.value, 0, aDRS.value.length);
        this.treeDigest.update(byArray2, 0, byArray2.length);
        this.treeDigest.update(byArray3, 0, byArray3.length);
        this.treeDigest.doFinal(byArray4, 0, byArray4.length);
        return byArray4;
    }

    @Override
    IndexedDigest H_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        int n = (this.A * this.K + 7) / 8;
        int n2 = this.H / this.D;
        int n3 = this.H - n2;
        int n4 = (n2 + 7) / 8;
        int n5 = (n3 + 7) / 8;
        int n6 = n + n4 + n5;
        byte[] byArray6 = new byte[n6];
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(byArray2, 0, byArray2.length);
        this.treeDigest.update(byArray3, 0, byArray3.length);
        if (byArray4 != null) {
            this.treeDigest.update(byArray4, 0, byArray4.length);
        }
        this.treeDigest.update(byArray5, 0, byArray5.length);
        this.treeDigest.doFinal(byArray6, 0, byArray6.length);
        byte[] byArray7 = new byte[8];
        System.arraycopy(byArray6, n, byArray7, 8 - n5, n5);
        long l = Pack.bigEndianToLong(byArray7, 0);
        byte[] byArray8 = new byte[4];
        System.arraycopy(byArray6, n + n5, byArray8, 4 - n4, n4);
        int n7 = Pack.bigEndianToInt(byArray8, 0);
        return new IndexedDigest(l &= -1L >>> 64 - n3, n7 &= -1 >>> 32 - n2, Arrays.copyOfRange(byArray6, 0, n));
    }

    @Override
    byte[] T_l(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = byArray2;
        byte[] byArray4 = new byte[this.N];
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(aDRS.value, 0, aDRS.value.length);
        this.treeDigest.update(byArray3, 0, byArray3.length);
        this.treeDigest.doFinal(byArray4, 0, byArray4.length);
        return byArray4;
    }

    @Override
    byte[] PRF(byte[] byArray, byte[] byArray2, ADRS aDRS) {
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(aDRS.value, 0, aDRS.value.length);
        this.treeDigest.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[this.N];
        this.treeDigest.doFinal(byArray3, 0, this.N);
        return byArray3;
    }

    @Override
    public byte[] PRF_msg(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.treeDigest.update(byArray, 0, byArray.length);
        this.treeDigest.update(byArray2, 0, byArray2.length);
        if (byArray3 != null) {
            this.treeDigest.update(byArray3, 0, byArray3.length);
        }
        this.treeDigest.update(byArray4, 0, byArray4.length);
        byte[] byArray5 = new byte[this.N];
        this.treeDigest.doFinal(byArray5, 0, byArray5.length);
        return byArray5;
    }

    protected byte[] bitmask(byte[] byArray, ADRS aDRS, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray2.length];
        this.maskDigest.update(byArray, 0, byArray.length);
        this.maskDigest.update(aDRS.value, 0, aDRS.value.length);
        this.maskDigest.doFinal(byArray3, 0, byArray3.length);
        Bytes.xorTo(byArray2.length, byArray2, byArray3);
        return byArray3;
    }

    protected byte[] bitmask(byte[] byArray, ADRS aDRS, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        this.maskDigest.update(byArray, 0, byArray.length);
        this.maskDigest.update(aDRS.value, 0, aDRS.value.length);
        this.maskDigest.doFinal(byArray4, 0, byArray4.length);
        Bytes.xorTo(byArray2.length, byArray2, byArray4);
        Bytes.xorTo(byArray3.length, byArray3, 0, byArray4, byArray2.length);
        return byArray4;
    }
}

