/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JsseUtils {
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static String getAuthTypeClient(short s) throws IOException {
        switch (s) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeServer(int n) throws IOException {
        switch (n) {
            case 11: {
                return "DH_anon";
            }
            case 7: {
                return "DH_DSS";
            }
            case 9: {
                return "DH_RSA";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 14: {
                return "DHE_PSK";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 20: {
                return "ECDH_anon";
            }
            case 16: {
                return "ECDH_ECDSA";
            }
            case 18: {
                return "ECDH_RSA";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 24: {
                return "ECDHE_PSK";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 1: {
                return "RSA";
            }
            case 15: {
                return "RSA_PSK";
            }
            case 21: {
                return "SRP";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static Certificate getCertificateMessage(TlsCrypto tlsCrypto, X509Certificate[] x509CertificateArray) throws IOException {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[x509CertificateArray.length];
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                tlsCertificateArray[i] = tlsCrypto.createCertificate(x509CertificateArray[i].getEncoded());
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TlsFatalAlert(80, (Throwable)certificateEncodingException);
        }
        return new Certificate(tlsCertificateArray);
    }

    public static X509Certificate[] getX509CertificateChain(Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return EMPTY_CHAIN;
        }
        DefaultJcaJceHelper defaultJcaJceHelper = new DefaultJcaJceHelper();
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificate.getLength()];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray[i] = JcaTlsCertificate.convert(certificate.getCertificateAt(i), (JcaJceHelper)defaultJcaJceHelper).getX509Certificate();
            }
            return x509CertificateArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static X509Certificate[] getX509CertificateChain(java.security.cert.Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        if (certificateArray instanceof X509Certificate[]) {
            return (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            java.security.cert.Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) {
                return null;
            }
            x509CertificateArray[i] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }

    public static X500Principal getSubject(Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return null;
        }
        DefaultJcaJceHelper defaultJcaJceHelper = new DefaultJcaJceHelper();
        try {
            return JcaTlsCertificate.convert(certificate.getCertificateAt(0), (JcaJceHelper)defaultJcaJceHelper).getX509Certificate().getSubjectX500Principal();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static String getAlertLogMessage(String string, short s, short s2) {
        return string + " " + AlertLevel.getText(s) + " " + AlertDescription.getText(s2) + " alert";
    }

    static Vector getSupportedSignatureAlgorithms(TlsCrypto tlsCrypto) {
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 3};
        Vector vector = new Vector();
        for (int i = 0; i < sArray2.length; ++i) {
            for (int j = 0; j < sArray.length; ++j) {
                JsseUtils.addIfSupported(tlsCrypto, vector, new SignatureAndHashAlgorithm(sArray[j], sArray2[i]));
            }
        }
        JsseUtils.addIfSupported(tlsCrypto, vector, new SignatureAndHashAlgorithm(2, 2));
        return vector;
    }

    static Set<X500Principal> toX500Principals(X500Name[] x500NameArray) throws IOException {
        if (x500NameArray == null || x500NameArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>(x500NameArray.length);
        for (int i = 0; i < x500NameArray.length; ++i) {
            X500Name x500Name = x500NameArray[i];
            if (x500Name == null) continue;
            hashSet.add(new X500Principal(x500Name.getEncoded("DER")));
        }
        return hashSet;
    }

    static X500Name toX500Name(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof X500Principal) {
            return X500Name.getInstance((Object)((X500Principal)principal).getEncoded());
        }
        return new X500Name(principal.getName());
    }

    static Set<X500Name> toX500Names(Principal[] principalArray) {
        if (principalArray == null || principalArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Name> hashSet = new HashSet<X500Name>(principalArray.length);
        for (int i = 0; i != principalArray.length; ++i) {
            X500Name x500Name = JsseUtils.toX500Name(principalArray[i]);
            if (x500Name == null) continue;
            hashSet.add(x500Name);
        }
        return hashSet;
    }

    private static void addIfSupported(TlsCrypto tlsCrypto, Vector vector, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        if (tlsCrypto.hasSignatureAndHashAlgorithm(signatureAndHashAlgorithm)) {
            vector.addElement(signatureAndHashAlgorithm);
        }
    }
}

