/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Map<String, Integer> supportedCipherSuites = ProvSSLContextSpi.createSupportedCipherSuites();
    private static final Map<String, ProtocolVersion> supportedProtocols = ProvSSLContextSpi.createSupportedProtocols();
    protected final TlsCryptoProvider cryptoProvider;
    protected final String[] defaultProtocols;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509KeyManager km;
    private X509TrustManager tm;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static Map<String, Integer> createSupportedCipherSuites() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(){

            @Override
            public Integer put(String string, Integer n) {
                if (null != super.put(string, n)) {
                    throw new IllegalStateException("Duplicate names in supported-cipher-suites");
                }
                return null;
            }
        };
        hashMap.put("TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        hashMap.put("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        hashMap.put("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        hashMap.put("TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        hashMap.put("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        hashMap.put("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        hashMap.put("TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        hashMap.put("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        hashMap.put("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        hashMap.put("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        hashMap.put("TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        hashMap.put("TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        hashMap.put("TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        hashMap.put("TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        hashMap.put("TLS_RSA_WITH_AES_128_CCM", 49308);
        hashMap.put("TLS_RSA_WITH_AES_128_CCM_8", 49312);
        hashMap.put("TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        hashMap.put("TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        hashMap.put("TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        hashMap.put("TLS_RSA_WITH_AES_256_CCM", 49309);
        hashMap.put("TLS_RSA_WITH_AES_256_CCM_8", 49313);
        hashMap.put("TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        hashMap.put("TLS_RSA_WITH_NULL_SHA", 2);
        hashMap.put("TLS_RSA_WITH_NULL_SHA256", 59);
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocols() {
        HashMap<String, ProtocolVersion> hashMap = new HashMap<String, ProtocolVersion>();
        hashMap.put("TLSv1", ProtocolVersion.TLSv10);
        hashMap.put("TLSv1.1", ProtocolVersion.TLSv11);
        hashMap.put("TLSv1.2", ProtocolVersion.TLSv12);
        return Collections.unmodifiableMap(hashMap);
    }

    ProvSSLContextSpi(TlsCryptoProvider tlsCryptoProvider) {
        this(tlsCryptoProvider, new String[]{"TLSv1.2"});
    }

    ProvSSLContextSpi(TlsCryptoProvider tlsCryptoProvider, String[] stringArray) {
        this.cryptoProvider = tlsCryptoProvider;
        this.defaultProtocols = stringArray;
    }

    int[] convertCipherSuites(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = supportedCipherSuites.get(stringArray[i]);
        }
        return nArray;
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this);
    }

    String getCipherSuiteString(int n) {
        if (TlsUtils.isValidUint16(n)) {
            for (Map.Entry<String, Integer> entry : supportedCipherSuites.entrySet()) {
                if (entry.getValue() != n) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getDefaultCipherSuites() {
        return new String[]{"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA"};
    }

    String[] getDefaultProtocols() {
        return this.defaultProtocols;
    }

    ProtocolVersion getMaximumVersion(String[] stringArray) {
        ProtocolVersion protocolVersion = null;
        if (stringArray != null) {
            for (String string : stringArray) {
                ProtocolVersion protocolVersion2;
                if (string == null || (protocolVersion2 = supportedProtocols.get(string)) == null || protocolVersion != null && !protocolVersion2.isLaterVersionOf(protocolVersion)) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    ProtocolVersion getMinimumVersion(String[] stringArray) {
        ProtocolVersion protocolVersion = null;
        if (stringArray != null) {
            for (String string : stringArray) {
                ProtocolVersion protocolVersion2;
                if (string == null || (protocolVersion2 = supportedProtocols.get(string)) == null || protocolVersion != null && !protocolVersion.isLaterVersionOf(protocolVersion2)) continue;
                protocolVersion = protocolVersion2;
            }
        }
        return protocolVersion;
    }

    String getProtocolString(ProtocolVersion protocolVersion) {
        if (protocolVersion != null) {
            for (Map.Entry<String, ProtocolVersion> entry : supportedProtocols.entrySet()) {
                if (!protocolVersion.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    String[] getSupportedCipherSuites() {
        return supportedCipherSuites.keySet().toArray(new String[supportedCipherSuites.size()]);
    }

    String[] getSupportedProtocols() {
        return supportedProtocols.keySet().toArray(new String[supportedProtocols.size()]);
    }

    boolean isSupportedCipherSuites(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null && supportedCipherSuites.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    boolean isSupportedProtocols(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null && supportedProtocols.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String string, int n) {
        this.checkInitialized();
        return new ProvSSLEngine(this, this.createContextData(), string, n);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(this.getDefaultCipherSuites());
        sSLParameters.setProtocols(this.getDefaultProtocols());
        return sSLParameters;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() {
        SSLParameters sSLParameters = new SSLParameters();
        sSLParameters.setCipherSuites(this.getSupportedCipherSuites());
        sSLParameters.setProtocols(this.getSupportedProtocols());
        return sSLParameters;
    }

    @Override
    protected synchronized void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(secureRandom);
        this.km = this.selectKeyManager(keyManagerArray);
        this.tm = this.selectTrustManager(trustManagerArray);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.km, this.tm, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509KeyManager findX509KeyManager(KeyManager[] keyManagerArray) {
        if (keyManagerArray != null) {
            for (KeyManager keyManager : keyManagerArray) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                return (X509KeyManager)keyManager;
            }
        }
        return null;
    }

    protected X509TrustManager findX509TrustManager(TrustManager[] trustManagerArray) {
        if (trustManagerArray != null) {
            for (TrustManager trustManager : trustManagerArray) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
        }
        return null;
    }

    protected X509KeyManager selectKeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        if (keyManagerArray == null) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(null, null);
                keyManagerArray = keyManagerFactory.getKeyManagers();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new KeyManagementException(generalSecurityException);
            }
        }
        return this.findX509KeyManager(keyManagerArray);
    }

    protected X509TrustManager selectTrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new KeyManagementException(generalSecurityException);
            }
        }
        return this.findX509TrustManager(trustManagerArray);
    }
}

