/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    protected ProvSSLEngine(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        super(string, n);
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol();
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol();
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.closeInput();
        }
        catch (IOException iOException) {
            throw new SSLException(iOException);
        }
    }

    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public synchronized SSLSession getSession() {
        return this.connection == null ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (!this.context.isSupportedCipherSuites(stringArray)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sSLParameters);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun && bl != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = bl;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        int n3;
        Object object;
        int n4;
        int n5;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        int n6 = 0;
        int n7 = 0;
        if (!this.protocol.isClosed()) {
            n5 = ProvSSLSession.NULL_SESSION.getApplicationBufferSize() + 5;
            n4 = Math.min(byteBuffer.remaining(), n5);
            if (n4 > 0) {
                object = new byte[n4];
                byteBuffer.get((byte[])object);
                try {
                    this.protocol.offerInput((byte[])object);
                }
                catch (IOException iOException) {
                    throw new SSLException(iOException);
                }
                n6 += n4;
                n5 -= n4;
            }
        }
        n5 = this.protocol.getAvailableInputBytes();
        for (n4 = 0; n4 < n2 && n5 > 0; n5 -= n3, ++n4) {
            object = byteBufferArray[n4];
            n3 = Math.min(object.remaining(), n5);
            byte[] byArray = new byte[n3];
            int n8 = this.protocol.readInput(byArray, 0, n3);
            assert (n8 == n3);
            object.put(byArray);
            n7 += n3;
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        if (n5 > 0) {
            status = SSLEngineResult.Status.BUFFER_OVERFLOW;
        } else if (this.protocol.isClosed()) {
            status = SSLEngineResult.Status.CLOSED;
        } else if (n6 == 0) {
            status = SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        object = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                object = (Object)SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                object = (Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(status, (SSLEngineResult.HandshakeStatus)((Object)object), n6, n7);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        int n3;
        Object object;
        int n4;
        int n5;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status status = SSLEngineResult.Status.OK;
        int n6 = 0;
        int n7 = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                status = SSLEngineResult.Status.CLOSED;
            } else {
                n5 = ProvSSLSession.NULL_SESSION.getApplicationBufferSize();
                for (n4 = 0; n4 < n2 && n5 > 0; ++n4) {
                    object = byteBufferArray[n4];
                    n3 = Math.min(((Buffer)object).remaining(), n5);
                    if (n3 <= 0) continue;
                    byte[] byArray = new byte[n3];
                    ((ByteBuffer)object).get(byArray);
                    try {
                        this.protocol.writeApplicationData(byArray, 0, n3);
                    }
                    catch (IOException iOException) {
                        throw new SSLException(iOException);
                    }
                    n6 += n3;
                    n5 -= n3;
                }
            }
        }
        if ((n5 = this.protocol.getAvailableOutputBytes()) > 0) {
            n4 = Math.min(byteBuffer.remaining(), n5);
            if (n4 > 0) {
                object = new byte[n4];
                n3 = this.protocol.readOutput((byte[])object, 0, n4);
                assert (n3 == n4);
                byteBuffer.put((byte[])object);
                n7 += n4;
                n5 -= n4;
            }
            if (n5 > 0) {
                status = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n5 <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(status, handshakeStatus, n6, n7);
    }

    public String getPeerHost() {
        return super.getPeerHost();
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        this.connection = provSSLConnection;
    }
}

