/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SessionBindingListenerAdapter;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.util.Arrays;

class ProvSSLSession
implements SSLSession {
    protected static final ProvSSLSession NULL_SESSION = new ProvSSLSession(null, null);
    protected final Map<String, Object> valueMap = Collections.synchronizedMap(new HashMap());
    protected final ProvSSLSessionContext sslSessionContext;
    protected final TlsSession tlsSession;
    protected final SessionParameters sessionParameters;

    ProvSSLSession(ProvSSLSessionContext provSSLSessionContext, TlsSession tlsSession) {
        this.sslSessionContext = provSSLSessionContext;
        this.tlsSession = tlsSession;
        this.sessionParameters = tlsSession == null ? null : tlsSession.exportSessionParameters();
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String getCipherSuite() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getCipherSuiteString(this.sessionParameters.getCipherSuite());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public byte[] getId() {
        return this.tlsSession == null ? null : Arrays.clone((byte[])this.tlsSession.getSessionID());
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public Certificate[] getLocalCertificates() {
        Certificate[] certificateArray;
        if (this.sessionParameters != null && (certificateArray = JsseUtils.getX509CertificateChain(this.sessionParameters.getLocalCertificate())) != null && certificateArray.length > 0) {
            return certificateArray;
        }
        return null;
    }

    public Principal getLocalPrincipal() {
        return this.sessionParameters == null ? null : JsseUtils.getSubject(this.sessionParameters.getLocalCertificate());
    }

    public int getPacketBufferSize() {
        return 18437;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        throw new UnsupportedOperationException();
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        Certificate[] certificateArray;
        if (this.sessionParameters != null && (certificateArray = JsseUtils.getX509CertificateChain(this.sessionParameters.getPeerCertificate())) != null && certificateArray.length > 0) {
            return certificateArray;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getPeerHost() {
        return null;
    }

    public int getPeerPort() {
        return -1;
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        X500Principal x500Principal;
        if (this.sessionParameters != null && (x500Principal = JsseUtils.getSubject(this.sessionParameters.getPeerCertificate())) != null) {
            return x500Principal;
        }
        throw new SSLPeerUnverifiedException("No peer identity established");
    }

    public String getProtocol() {
        return this.sessionParameters == null ? null : this.sslSessionContext.getSSLContext().getProtocolString(this.sessionParameters.getNegotiatedVersion());
    }

    public SSLSessionContext getSessionContext() {
        return this.sslSessionContext;
    }

    public Object getValue(String string) {
        return this.valueMap.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getValueNames() {
        Map<String, Object> map = this.valueMap;
        synchronized (map) {
            return this.valueMap.keySet().toArray(new String[this.valueMap.size()]);
        }
    }

    public void invalidate() {
        if (this.tlsSession != null) {
            this.tlsSession.invalidate();
        }
    }

    public boolean isValid() {
        return this.tlsSession != null && this.tlsSession.isResumable();
    }

    public void putValue(String string, Object object) {
        this.notifyUnbound(string, this.valueMap.put(string, object));
        this.notifyBound(string, object);
    }

    public void removeValue(String string) {
        this.notifyUnbound(string, this.valueMap.remove(string));
    }

    protected void notifyBound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueBound(new SSLSessionBindingEvent(this, string));
        }
    }

    protected void notifyUnbound(String string, Object object) {
        if (object instanceof SSLSessionBindingListener) {
            new SessionBindingListenerAdapter((SSLSessionBindingListener)object).valueUnbound(new SSLSessionBindingEvent(this, string));
        }
    }
}

