/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsMAC;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsStreamCipherImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class ChaCha20Poly1305Cipher
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsCryptoParameters context;
    protected TlsMAC writeMac;
    protected TlsMAC readMac;
    protected TlsStreamCipherImpl encryptCipher;
    protected TlsStreamCipherImpl decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public ChaCha20Poly1305Cipher(TlsCryptoParameters tlsCryptoParameters, TlsStreamCipherImpl tlsStreamCipherImpl, TlsStreamCipherImpl tlsStreamCipherImpl2, TlsMAC tlsMAC, TlsMAC tlsMAC2) throws IOException {
        byte[] byArray;
        byte[] byArray2;
        if (!TlsImplUtils.isTLSv12(tlsCryptoParameters)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsCryptoParameters;
        int n = 32;
        int n2 = 12;
        int n3 = 2 * n + 2 * n2;
        byte[] byArray3 = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n3);
        int n4 = 0;
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray3, (int)n4, (int)(n4 + n));
        byte[] byArray5 = Arrays.copyOfRange((byte[])byArray3, (int)(n4 += n), (int)(n4 + n));
        byte[] byArray6 = Arrays.copyOfRange((byte[])byArray3, (int)(n4 += n), (int)(n4 + n2));
        byte[] byArray7 = Arrays.copyOfRange((byte[])byArray3, (int)(n4 += n2), (int)(n4 + n2));
        if ((n4 += n2) != n3) {
            throw new TlsFatalAlert(80);
        }
        this.writeMac = tlsMAC;
        this.readMac = tlsMAC2;
        this.encryptCipher = tlsStreamCipherImpl;
        this.decryptCipher = tlsStreamCipherImpl2;
        if (tlsCryptoParameters.isServer()) {
            byArray2 = byArray5;
            byArray = byArray4;
            this.encryptIV = byArray7;
            this.decryptIV = byArray6;
        } else {
            byArray2 = byArray4;
            byArray = byArray5;
            this.encryptIV = byArray6;
            this.decryptIV = byArray7;
        }
        this.encryptCipher.setKey(byArray2);
        this.encryptCipher.init(this.encryptIV);
        this.decryptCipher.setKey(byArray);
        this.decryptCipher.init(this.decryptIV);
    }

    public int getPlaintextLimit(int n) {
        return n - 16;
    }

    public byte[] encodePlaintext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        this.initRecord(this.encryptCipher, l, this.encryptIV);
        byte[] byArray2 = new byte[64 + n2];
        System.arraycopy(byArray, n, byArray2, 64, n2);
        this.encryptCipher.doFinal(byArray2, 0, byArray2.length, byArray2, 0);
        byte[] byArray3 = new byte[n2 + 16];
        byte[] byArray4 = Arrays.copyOfRange((byte[])byArray2, (int)0, (int)32);
        System.arraycopy(byArray2, 64, byArray3, 0, n2);
        Arrays.fill((byte[])byArray2, (byte)0);
        this.writeMac.setKey(byArray4);
        byte[] byArray5 = this.getAdditionalData(l, s, n2);
        byte[] byArray6 = this.calculateRecordMAC(this.writeMac, byArray5, byArray3, 0, n2);
        System.arraycopy(byArray6, 0, byArray3, n2, byArray6.length);
        return byArray3;
    }

    public byte[] decodeCiphertext(long l, short s, byte[] byArray, int n, int n2) throws IOException {
        if (this.getPlaintextLimit(n2) < 0) {
            throw new TlsFatalAlert(50);
        }
        this.initRecord(this.decryptCipher, l, this.decryptIV);
        int n3 = n2 - 16;
        byte[] byArray2 = new byte[64 + n3];
        System.arraycopy(byArray, n, byArray2, 64, n3);
        this.decryptCipher.doFinal(byArray2, 0, byArray2.length, byArray2, 0);
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray2, (int)0, (int)32);
        this.readMac.setKey(byArray3);
        byte[] byArray4 = this.getAdditionalData(l, s, n3);
        byte[] byArray5 = this.calculateRecordMAC(this.readMac, byArray4, byArray, n, n3);
        byte[] byArray6 = Arrays.copyOfRange((byte[])byArray, (int)(n + n3), (int)(n + n2));
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray2, 64, byArray7, 0, n3);
        Arrays.fill((byte[])byArray2, (byte)0);
        if (!Arrays.constantTimeAreEqual((byte[])byArray5, (byte[])byArray6)) {
            throw new TlsFatalAlert(20);
        }
        return byArray7;
    }

    protected void initRecord(TlsStreamCipherImpl tlsStreamCipherImpl, long l, byte[] byArray) throws IOException {
        byte[] byArray2 = this.calculateNonce(l, byArray);
        tlsStreamCipherImpl.init(byArray2);
    }

    protected byte[] calculateNonce(long l, byte[] byArray) {
        byte[] byArray2 = new byte[12];
        TlsUtils.writeUint64(l, byArray2, 4);
        for (int i = 0; i < 12; ++i) {
            int n = i;
            byArray2[n] = (byte)(byArray2[n] ^ byArray[i]);
        }
        return byArray2;
    }

    protected byte[] calculateRecordMAC(TlsMAC tlsMAC, byte[] byArray, byte[] byArray2, int n, int n2) {
        this.updateRecordMACText(tlsMAC, byArray, 0, byArray.length);
        this.updateRecordMACText(tlsMAC, byArray2, n, n2);
        this.updateRecordMACLength(tlsMAC, byArray.length);
        this.updateRecordMACLength(tlsMAC, n2);
        return tlsMAC.calculateMAC();
    }

    protected void updateRecordMACLength(TlsMAC tlsMAC, int n) {
        byte[] byArray = Pack.longToLittleEndian((long)((long)n & 0xFFFFFFFFL));
        tlsMAC.update(byArray, 0, byArray.length);
    }

    protected void updateRecordMACText(TlsMAC tlsMAC, byte[] byArray, int n, int n2) {
        tlsMAC.update(byArray, n, n2);
        int n3 = n2 % 16;
        if (n3 != 0) {
            tlsMAC.update(ZEROES, 0, 16 - n3);
        }
    }

    protected byte[] getAdditionalData(long l, short s, int n) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64(l, byArray, 0);
        TlsUtils.writeUint8(s, byArray, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), byArray, 9);
        TlsUtils.writeUint16(n, byArray, 11);
        return byArray;
    }
}

