/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.BigIntegers;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto bcTlsCrypto, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (bcTlsCrypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new DHCredentialedAgreement(bcTlsCrypto, asymmetricKeyParameter, certificate);
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new ECCredentialedAgreement(bcTlsCrypto, asymmetricKeyParameter, certificate);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
    }

    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(tlsCertificate);
    }

    private class DHCredentialedAgreement
    implements TlsCredentialedAgreement {
        private final Certificate certificate;
        private final BcTlsCrypto crypto;
        protected AsymmetricKeyParameter privateKey;
        protected BasicAgreement basicAgreement = new DHBasicAgreement();

        public DHCredentialedAgreement(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate) {
            this.crypto = bcTlsCrypto;
            this.privateKey = asymmetricKeyParameter;
            this.certificate = certificate;
        }

        public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
            TlsCertificate tlsCertificate2 = this.certificate.getCertificateAt(0);
            AsymmetricKeyParameter asymmetricKeyParameter = BcTlsCertificate.convert(this.crypto, tlsCertificate2).getPublicKey();
            this.basicAgreement.init((CipherParameters)this.privateKey);
            BigInteger bigInteger = this.basicAgreement.calculateAgreement((CipherParameters)asymmetricKeyParameter);
            return this.crypto.adoptLocalSecret(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }

    private class ECCredentialedAgreement
    implements TlsCredentialedAgreement {
        private final Certificate certificate;
        private final BcTlsCrypto crypto;
        private final AsymmetricKeyParameter privateKey;
        protected BasicAgreement basicAgreement = new ECDHBasicAgreement();

        public ECCredentialedAgreement(BcTlsCrypto bcTlsCrypto, AsymmetricKeyParameter asymmetricKeyParameter, Certificate certificate) {
            this.crypto = bcTlsCrypto;
            this.privateKey = asymmetricKeyParameter;
            this.certificate = certificate;
        }

        public TlsSecret generateAgreement(TlsCertificate tlsCertificate) throws IOException {
            TlsCertificate tlsCertificate2 = this.certificate.getCertificateAt(0);
            AsymmetricKeyParameter asymmetricKeyParameter = BcTlsCertificate.convert(this.crypto, tlsCertificate2).getPublicKey();
            this.basicAgreement.init((CipherParameters)this.privateKey);
            BigInteger bigInteger = this.basicAgreement.calculateAgreement((CipherParameters)asymmetricKeyParameter);
            return this.crypto.adoptLocalSecret(BigIntegers.asUnsignedByteArray((int)this.basicAgreement.getFieldSize(), (BigInteger)bigInteger));
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

