/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsRSAVerifier;

public class BcTlsCertificate
implements TlsCertificate {
    private final BcTlsCrypto crypto;
    protected final Certificate certificate;
    protected DHPublicKeyParameters pubKeyDH = null;
    protected ECPublicKeyParameters pubKeyEC = null;
    protected RSAKeyParameters pubKeyRSA = null;

    public static BcTlsCertificate convert(BcTlsCrypto bcTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)tlsCertificate;
        }
        return new BcTlsCertificate(bcTlsCrypto, tlsCertificate.getEncoded());
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, byte[] byArray) throws IOException {
        this.crypto = bcTlsCrypto;
        try {
            this.certificate = Certificate.getInstance((Object)byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("unable to decode certificate: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public TlsVerifier createVerifier(short s) throws IOException {
        this.validateKeyUsage(128);
        switch (s) {
            case 2: {
                return new BcTlsDSAVerifier(this.crypto, this.getPubKeyDSS());
            }
            case 3: {
                return new BcTlsECDSAVerifier(this.crypto, this.getPubKeyEC());
            }
            case 1: {
                return new BcTlsRSAVerifier(this.getPubKeyRSA());
            }
        }
        throw new TlsFatalAlert(46);
    }

    public short getClientCertificateType() throws IOException {
        AsymmetricKeyParameter asymmetricKeyParameter = this.getPublicKey();
        if (asymmetricKeyParameter.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        try {
            if (asymmetricKeyParameter instanceof RSAKeyParameters) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(43, (Throwable)exception);
        }
        throw new TlsFatalAlert(43);
    }

    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    protected DHPublicKeyParameters getPubKeyDH() throws IOException {
        DHPublicKeyParameters dHPublicKeyParameters;
        try {
            dHPublicKeyParameters = (DHPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyDH(dHPublicKeyParameters);
    }

    public DSAPublicKeyParameters getPubKeyDSS() throws IOException {
        DSAPublicKeyParameters dSAPublicKeyParameters;
        try {
            dSAPublicKeyParameters = (DSAPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyDSS(dSAPublicKeyParameters);
    }

    public ECPublicKeyParameters getPubKeyEC() throws IOException {
        ECPublicKeyParameters eCPublicKeyParameters;
        try {
            eCPublicKeyParameters = (ECPublicKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyEC(eCPublicKeyParameters);
    }

    public RSAKeyParameters getPubKeyRSA() throws IOException {
        RSAKeyParameters rSAKeyParameters;
        try {
            rSAKeyParameters = (RSAKeyParameters)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyRSA(rSAKeyParameters);
    }

    public TlsCertificate useInRole(int n, int n2) throws IOException {
        switch (n2) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (n == 0) {
            switch (n2) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected AsymmetricKeyParameter getPublicKey() throws IOException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificate.getSubjectPublicKeyInfo();
        try {
            return PublicKeyFactory.createKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    protected void validateKeyUsage(int n) throws IOException {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions((Extensions)extensions)) != null && ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) != n) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DHPublicKeyParameters validatePubKeyDH(DHPublicKeyParameters dHPublicKeyParameters) throws IOException {
        TlsDHUtils.validateDHPublicValues(dHPublicKeyParameters.getY(), dHPublicKeyParameters.getParameters().getP());
        return dHPublicKeyParameters;
    }

    protected DSAPublicKeyParameters validatePubKeyDSS(DSAPublicKeyParameters dSAPublicKeyParameters) throws IOException {
        return dSAPublicKeyParameters;
    }

    protected ECPublicKeyParameters validatePubKeyEC(ECPublicKeyParameters eCPublicKeyParameters) throws IOException {
        return eCPublicKeyParameters;
    }

    protected RSAKeyParameters validatePubKeyRSA(RSAKeyParameters rSAKeyParameters) throws IOException {
        return rSAKeyParameters;
    }
}

