/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_8
extends JsseUtils {
    JsseUtils_8() {
    }

    static SNIMatcher exportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
        if (bCSNIMatcher == null) {
            return null;
        }
        if (bCSNIMatcher instanceof ImportSNIMatcher) {
            return ((ImportSNIMatcher)bCSNIMatcher).unwrap();
        }
        return new ExportSNIMatcher(bCSNIMatcher);
    }

    static Object exportSNIMatchers(Collection<BCSNIMatcher> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<SNIMatcher> arrayList = new ArrayList<SNIMatcher>(collection.size());
        for (BCSNIMatcher bCSNIMatcher : collection) {
            SNIMatcher sNIMatcher = JsseUtils_8.exportSNIMatcher(bCSNIMatcher);
            if (sNIMatcher == null) continue;
            arrayList.add(sNIMatcher);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    static SNIHostName exportSNIServerName(BCSNIServerName bCSNIServerName) {
        if (bCSNIServerName == null || bCSNIServerName.getType() != 0) {
            return null;
        }
        return new SNIHostName(bCSNIServerName.getEncoded());
    }

    static Object exportSNIServerNames(Collection<BCSNIServerName> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<SNIHostName> arrayList = new ArrayList<SNIHostName>(collection.size());
        for (BCSNIServerName bCSNIServerName : collection) {
            SNIHostName sNIHostName = JsseUtils_8.exportSNIServerName(bCSNIServerName);
            if (sNIHostName == null) continue;
            arrayList.add(sNIHostName);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    static BCSNIMatcher importSNIMatcher(SNIMatcher sNIMatcher) {
        if (sNIMatcher == null) {
            return null;
        }
        if (sNIMatcher instanceof ExportSNIMatcher) {
            return ((ExportSNIMatcher)sNIMatcher).unwrap();
        }
        return new ImportSNIMatcher(sNIMatcher);
    }

    static List<BCSNIMatcher> importSNIMatchers(Object object) {
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        ArrayList<BCSNIMatcher> arrayList = new ArrayList<BCSNIMatcher>(collection.size());
        for (SNIMatcher sNIMatcher : collection) {
            BCSNIMatcher bCSNIMatcher = JsseUtils_8.importSNIMatcher(sNIMatcher);
            if (bCSNIMatcher == null) continue;
            arrayList.add(bCSNIMatcher);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    static BCSNIHostName importSNIServerName(SNIServerName sNIServerName) {
        if (sNIServerName == null || sNIServerName.getType() != 0) {
            return null;
        }
        return new BCSNIHostName(sNIServerName.getEncoded());
    }

    static List<BCSNIServerName> importSNIServerNames(Object object) {
        if (object == null) {
            return null;
        }
        Collection collection = (Collection)object;
        ArrayList<BCSNIHostName> arrayList = new ArrayList<BCSNIHostName>(collection.size());
        for (SNIServerName sNIServerName : collection) {
            BCSNIHostName bCSNIHostName = JsseUtils_8.importSNIServerName(sNIServerName);
            if (bCSNIHostName == null) continue;
            arrayList.add(bCSNIHostName);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    static class ExportSNIMatcher
    extends SNIMatcher {
        private final BCSNIMatcher matcher;

        ExportSNIMatcher(BCSNIMatcher bCSNIMatcher) {
            super(bCSNIMatcher.getType());
            this.matcher = bCSNIMatcher;
        }

        public boolean matches(SNIServerName sNIServerName) {
            return this.matcher.matches(JsseUtils_8.importSNIServerName(sNIServerName));
        }

        BCSNIMatcher unwrap() {
            return this.matcher;
        }
    }

    static class ImportSNIMatcher
    extends BCSNIMatcher {
        private final SNIMatcher matcher;

        ImportSNIMatcher(SNIMatcher sNIMatcher) {
            super(sNIMatcher.getType());
            this.matcher = sNIMatcher;
        }

        public boolean matches(BCSNIServerName bCSNIServerName) {
            return this.matcher.matches(JsseUtils_8.exportSNIServerName(bCSNIServerName));
        }

        SNIMatcher unwrap() {
            return this.matcher;
        }
    }
}

