/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SSLParametersUtil {
    private static final Method getAlgorithmConstraints;
    private static final Method setAlgorithmConstraints;
    private static final Method getEndpointIdentificationAlgorithm;
    private static final Method setEndpointIdentificationAlgorithm;
    private static final Method getServerNames;
    private static final Method setServerNames;
    private static final Method getSNIMatchers;
    private static final Method setSNIMatchers;
    private static final Method getUseCipherSuitesOrder;
    private static final Method setUseCipherSuitesOrder;

    SSLParametersUtil() {
    }

    private static Method findMethod(Method[] methodArray, String string) {
        if (methodArray != null) {
            for (Method method : methodArray) {
                if (!method.getName().equals(string)) continue;
                return method;
            }
        }
        return null;
    }

    private static Class<?> getClassPrivileged(final String string) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    ClassLoader classLoader = SSLParametersUtil.class.getClassLoader();
                    if (classLoader != null) {
                        return classLoader.loadClass(string);
                    }
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static Method[] getMethodsPrivileged(final Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                try {
                    return clazz.getMethods();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static Object invokeGetterPrivileged(final Object object, final Method method) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return method.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    private static void invokeSetterPrivileged(final Object object, final Method method, final Object object2) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    method.invoke(object, object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    static BCSSLParameters getParameters(ProvSSLParameters provSSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            bCSSLParameters.setWantClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(false);
        }
        bCSSLParameters.setServerNames(provSSLParameters.getServerNames());
        bCSSLParameters.setSNIMatchers(provSSLParameters.getSNIMatchers());
        return bCSSLParameters;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters provSSLParameters) {
        SSLParameters sSLParameters = new SSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(false);
        }
        if (setAlgorithmConstraints != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setAlgorithmConstraints, provSSLParameters.getAlgorithmConstraints());
        }
        if (setEndpointIdentificationAlgorithm != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setEndpointIdentificationAlgorithm, provSSLParameters.getEndpointIdentificationAlgorithm());
        }
        if (setUseCipherSuitesOrder != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setUseCipherSuitesOrder, provSSLParameters.getUseCipherSuitesOrder());
        }
        if (setServerNames != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setServerNames, JsseUtils_8.exportSNIServerNames(provSSLParameters.getServerNames()));
        }
        if (setSNIMatchers != null) {
            SSLParametersUtil.invokeSetterPrivileged(sSLParameters, setSNIMatchers, JsseUtils_8.exportSNIMatchers(provSSLParameters.getSNIMatchers()));
        }
        return sSLParameters;
    }

    static void setParameters(ProvSSLParameters provSSLParameters, BCSSLParameters bCSSLParameters) {
        Collection<BCSNIMatcher> collection;
        String[] stringArray;
        String[] stringArray2 = bCSSLParameters.getCipherSuites();
        if (stringArray2 != null) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if ((stringArray = bCSSLParameters.getProtocols()) != null) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (bCSSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (bCSSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        List<BCSNIServerName> list = bCSSLParameters.getServerNames();
        if (list != null) {
            provSSLParameters.setServerNames(list);
        }
        if ((collection = bCSSLParameters.getSNIMatchers()) != null) {
            provSSLParameters.setSNIMatchers(collection);
        }
    }

    static void setSSLParameters(ProvSSLParameters provSSLParameters, SSLParameters sSLParameters) {
        Object object;
        String[] stringArray;
        String[] stringArray2 = sSLParameters.getCipherSuites();
        if (stringArray2 != null) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if ((stringArray = sSLParameters.getProtocols()) != null) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        if (getAlgorithmConstraints != null) {
            provSSLParameters.setAlgorithmConstraints(SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getAlgorithmConstraints));
        }
        if (getEndpointIdentificationAlgorithm != null) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getEndpointIdentificationAlgorithm));
        }
        if (getUseCipherSuitesOrder != null) {
            provSSLParameters.setUseCipherSuitesOrder((Boolean)SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getUseCipherSuitesOrder));
        }
        if (getServerNames != null && (object = SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getServerNames)) != null) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(object));
        }
        if (getSNIMatchers != null && (object = SSLParametersUtil.invokeGetterPrivileged(sSLParameters, getSNIMatchers)) != null) {
            provSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(object));
        }
    }

    static {
        Class<?> clazz = SSLParametersUtil.getClassPrivileged("javax.net.ssl.SSLParameters");
        Method[] methodArray = SSLParametersUtil.getMethodsPrivileged(clazz);
        getAlgorithmConstraints = SSLParametersUtil.findMethod(methodArray, "getAlgorithmConstraints");
        setAlgorithmConstraints = SSLParametersUtil.findMethod(methodArray, "setAlgorithmConstraints");
        getEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methodArray, "getEndpointIdentificationAlgorithm");
        setEndpointIdentificationAlgorithm = SSLParametersUtil.findMethod(methodArray, "setEndpointIdentificationAlgorithm");
        getServerNames = SSLParametersUtil.findMethod(methodArray, "getServerNames");
        setServerNames = SSLParametersUtil.findMethod(methodArray, "setServerNames");
        getSNIMatchers = SSLParametersUtil.findMethod(methodArray, "getSNIMatchers");
        setSNIMatchers = SSLParametersUtil.findMethod(methodArray, "setSNIMatchers");
        getUseCipherSuitesOrder = SSLParametersUtil.findMethod(methodArray, "getUseCipherSuitesOrder");
        setUseCipherSuitesOrder = SSLParametersUtil.findMethod(methodArray, "setUseCipherSuitesOrder");
    }
}

