/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCryptoException;
import org.bouncycastle.tls.crypto.TlsVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSAVerifier;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAVerifier;

public class JcaTlsCertificate
implements TlsCertificate {
    protected final JcaTlsCrypto crypto;
    protected final X509Certificate certificate;
    protected DHPublicKey pubKeyDH = null;
    protected ECPublicKey pubKeyEC = null;
    protected RSAPublicKey pubKeyRSA = null;

    public static JcaTlsCertificate convert(JcaTlsCrypto jcaTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof JcaTlsCertificate) {
            return (JcaTlsCertificate)tlsCertificate;
        }
        return new JcaTlsCertificate(jcaTlsCrypto, tlsCertificate.getEncoded());
    }

    public static X509Certificate parseCertificate(JcaJceHelper jcaJceHelper, byte[] byArray) throws IOException {
        try {
            byte[] byArray2 = Certificate.getInstance((Object)byArray).getEncoded("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            X509Certificate x509Certificate = (X509Certificate)jcaJceHelper.createCertificateFactory("X.509").generateCertificate(byteArrayInputStream);
            if (byteArrayInputStream.available() != 0) {
                throw new IOException("Extra data detected in stream");
            }
            return x509Certificate;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("unable to decode certificate", generalSecurityException);
        }
    }

    public JcaTlsCertificate(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) throws IOException {
        this(jcaTlsCrypto, JcaTlsCertificate.parseCertificate(jcaTlsCrypto.getHelper(), byArray));
    }

    public JcaTlsCertificate(JcaTlsCrypto jcaTlsCrypto, X509Certificate x509Certificate) {
        this.crypto = jcaTlsCrypto;
        this.certificate = x509Certificate;
    }

    public TlsVerifier createVerifier(short s) throws IOException {
        this.validateKeyUsage(128);
        switch (s) {
            case 2: {
                return new JcaTlsDSAVerifier(this.getPubKeyDSS(), this.crypto.getHelper());
            }
            case 3: {
                return new JcaTlsECDSAVerifier(this.getPubKeyEC(), this.crypto.getHelper());
            }
            case 1: {
                return new JcaTlsRSAVerifier(this.getPubKeyRSA(), this.crypto.getHelper());
            }
        }
        throw new TlsFatalAlert(46);
    }

    public short getClientCertificateType() throws IOException {
        PublicKey publicKey = this.getPublicKey();
        try {
            if (publicKey instanceof RSAPublicKey) {
                this.validateKeyUsage(128);
                return 1;
            }
            if (publicKey instanceof DSAPublicKey) {
                this.validateKeyUsage(128);
                return 2;
            }
            if (publicKey instanceof ECPublicKey) {
                this.validateKeyUsage(128);
                return 64;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(43, (Throwable)exception);
        }
        throw new TlsFatalAlert(43);
    }

    public byte[] getEncoded() throws IOException {
        try {
            return this.certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TlsCryptoException("unable to encode certificate: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        byte[] byArray = this.certificate.getExtensionValue(aSN1ObjectIdentifier.getId());
        return byArray == null ? null : ((ASN1OctetString)ASN1Primitive.fromByteArray((byte[])byArray)).getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber();
    }

    public String getSigAlgOID() {
        return this.certificate.getSigAlgOID();
    }

    DHPublicKey getPubKeyDH() throws IOException {
        DHPublicKey dHPublicKey;
        try {
            dHPublicKey = (DHPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyDH(dHPublicKey);
    }

    DSAPublicKey getPubKeyDSS() throws IOException {
        DSAPublicKey dSAPublicKey;
        try {
            dSAPublicKey = (DSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyDSS(dSAPublicKey);
    }

    ECPublicKey getPubKeyEC() throws IOException {
        ECPublicKey eCPublicKey;
        try {
            eCPublicKey = (ECPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyEC(eCPublicKey);
    }

    RSAPublicKey getPubKeyRSA() throws IOException {
        RSAPublicKey rSAPublicKey;
        try {
            rSAPublicKey = (RSAPublicKey)this.getPublicKey();
        }
        catch (ClassCastException classCastException) {
            throw new TlsFatalAlert(46, (Throwable)classCastException);
        }
        return this.validatePubKeyRSA(rSAPublicKey);
    }

    public TlsCertificate useInRole(int n, int n2) throws IOException {
        switch (n2) {
            case 7: 
            case 9: {
                this.validateKeyUsage(8);
                this.pubKeyDH = this.getPubKeyDH();
                return this;
            }
            case 16: 
            case 18: {
                this.validateKeyUsage(8);
                this.pubKeyEC = this.getPubKeyEC();
                return this;
            }
        }
        if (n == 0) {
            switch (n2) {
                case 1: 
                case 15: {
                    this.validateKeyUsage(32);
                    this.pubKeyRSA = this.getPubKeyRSA();
                    return this;
                }
            }
        }
        throw new TlsFatalAlert(46);
    }

    protected PublicKey getPublicKey() throws IOException {
        try {
            return this.certificate.getPublicKey();
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43, (Throwable)runtimeException);
        }
    }

    public X509Certificate getX509Certificate() {
        return this.certificate;
    }

    protected void validateKeyUsage(int n) throws IOException {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions;
        try {
            extensions = TBSCertificate.getInstance((Object)this.certificate.getTBSCertificate()).getExtensions();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TlsCryptoException("unable to parse certificate extensions: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
        if (extensions != null && (keyUsage = KeyUsage.fromExtensions((Extensions)extensions)) != null && ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) != n) {
            throw new TlsFatalAlert(46);
        }
    }

    protected DHPublicKey validatePubKeyDH(DHPublicKey dHPublicKey) throws IOException {
        return dHPublicKey;
    }

    protected DSAPublicKey validatePubKeyDSS(DSAPublicKey dSAPublicKey) throws IOException {
        return dSAPublicKey;
    }

    protected ECPublicKey validatePubKeyEC(ECPublicKey eCPublicKey) throws IOException {
        return eCPublicKey;
    }

    protected RSAPublicKey validatePubKeyRSA(RSAPublicKey rSAPublicKey) throws IOException {
        return rSAPublicKey;
    }
}

