// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;


/**
 * Stream structure.
 * New fields can be added to the end with minor version bumps.
 * Removal, reordering and changes to existing fields require a major
 * version bump.
 * sizeof(AVStream) must not be used outside libav*.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVStream extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVStream() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVStream(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVStream(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVStream position(long position) {
        return (AVStream)super.position(position);
    }
    @Override public AVStream getPointer(long i) {
        return new AVStream((Pointer)this).position(position + i);
    }

    /** stream index in AVFormatContext */
    public native int index(); public native AVStream index(int setter);
    /**
     * Format-specific stream ID.
     * decoding: set by libavformat
     * encoding: set by the user, replaced by libavformat if left unset
     */
    public native int id(); public native AVStream id(int setter);
// #if FF_API_LAVF_AVCTX
    /**
     * @deprecated use the codecpar struct instead
     */
    public native @Deprecated AVCodecContext codec(); public native AVStream codec(AVCodecContext setter);
// #endif
    public native Pointer priv_data(); public native AVStream priv_data(Pointer setter);

    /**
     * This is the fundamental unit of time (in seconds) in terms
     * of which frame timestamps are represented.
     *
     * decoding: set by libavformat
     * encoding: May be set by the caller before avformat_write_header() to
     *           provide a hint to the muxer about the desired timebase. In
     *           avformat_write_header(), the muxer will overwrite this field
     *           with the timebase that will actually be used for the timestamps
     *           written into the file (which may or may not be related to the
     *           user-provided one, depending on the format).
     */
    public native @ByRef AVRational time_base(); public native AVStream time_base(AVRational setter);

    /**
     * Decoding: pts of the first frame of the stream in presentation order, in stream time base.
     * Only set this if you are absolutely 100% sure that the value you set
     * it to really is the pts of the first frame.
     * This may be undefined (AV_NOPTS_VALUE).
     * \note The ASF header does NOT contain a correct start_time the ASF
     * demuxer must NOT set this.
     */
    public native @Cast("int64_t") long start_time(); public native AVStream start_time(long setter);

    /**
     * Decoding: duration of the stream, in stream time base.
     * If a source file does not specify a duration, but does specify
     * a bitrate, this value will be estimated from bitrate and file size.
     *
     * Encoding: May be set by the caller before avformat_write_header() to
     * provide a hint to the muxer about the estimated duration.
     */
    public native @Cast("int64_t") long duration(); public native AVStream duration(long setter);

    /** number of frames in this stream if known or 0 */
    public native @Cast("int64_t") long nb_frames(); public native AVStream nb_frames(long setter);

    /** AV_DISPOSITION_* bit field */
    public native int disposition(); public native AVStream disposition(int setter);

    /** Selects which packets can be discarded at will and do not need to be demuxed. */
    public native @Cast("AVDiscard") int discard(); public native AVStream discard(int setter);

    /**
     * sample aspect ratio (0 if unknown)
     * - encoding: Set by user.
     * - decoding: Set by libavformat.
     */
    public native @ByRef AVRational sample_aspect_ratio(); public native AVStream sample_aspect_ratio(AVRational setter);

    public native AVDictionary metadata(); public native AVStream metadata(AVDictionary setter);

    /**
     * Average framerate
     *
     * - demuxing: May be set by libavformat when creating the stream or in
     *             avformat_find_stream_info().
     * - muxing: May be set by the caller before avformat_write_header().
     */
    public native @ByRef AVRational avg_frame_rate(); public native AVStream avg_frame_rate(AVRational setter);

    /**
     * For streams with AV_DISPOSITION_ATTACHED_PIC disposition, this packet
     * will contain the attached picture.
     *
     * decoding: set by libavformat, must not be modified by the caller.
     * encoding: unused
     */
    public native @ByRef AVPacket attached_pic(); public native AVStream attached_pic(AVPacket setter);

    /**
     * An array of side data that applies to the whole stream (i.e. the
     * container does not allow it to change between packets).
     *
     * There may be no overlap between the side data in this array and side data
     * in the packets. I.e. a given side data is either exported by the muxer
     * (demuxing) / set by the caller (muxing) in this array, then it never
     * appears in the packets, or the side data is exported / sent through
     * the packets (always in the first packet where the value becomes known or
     * changes), then it does not appear in this array.
     *
     * - demuxing: Set by libavformat when the stream is created.
     * - muxing: May be set by the caller before avformat_write_header().
     *
     * Freed by libavformat in avformat_free_context().
     *
     * @see av_format_inject_global_side_data()
     */
    public native AVPacketSideData side_data(); public native AVStream side_data(AVPacketSideData setter);
    /**
     * The number of elements in the AVStream.side_data array.
     */
    public native int nb_side_data(); public native AVStream nb_side_data(int setter);

    /**
     * Flags for the user to detect events happening on the stream. Flags must
     * be cleared by the user once the event has been handled.
     * A combination of AVSTREAM_EVENT_FLAG_*.
     */
    public native int event_flags(); public native AVStream event_flags(int setter);
/** The call resulted in updated metadata. */
public static final int AVSTREAM_EVENT_FLAG_METADATA_UPDATED = 0x0001;

    /**
     * Real base framerate of the stream.
     * This is the lowest framerate with which all timestamps can be
     * represented accurately (it is the least common multiple of all
     * framerates in the stream). Note, this value is just a guess!
     * For example, if the time base is 1/90000 and all frames have either
     * approximately 3600 or 1800 timer ticks, then r_frame_rate will be 50/1.
     */
    public native @ByRef AVRational r_frame_rate(); public native AVStream r_frame_rate(AVRational setter);

// #if FF_API_LAVF_FFSERVER
    /**
     * String containing pairs of key and values describing recommended encoder configuration.
     * Pairs are separated by ','.
     * Keys are separated from values by '='.
     *
     * @deprecated unused
     */
    public native @Cast("char*") @Deprecated BytePointer recommended_encoder_configuration(); public native AVStream recommended_encoder_configuration(BytePointer setter);
// #endif

    /**
     * Codec parameters associated with this stream. Allocated and freed by
     * libavformat in avformat_new_stream() and avformat_free_context()
     * respectively.
     *
     * - demuxing: filled by libavformat on stream creation or in
     *             avformat_find_stream_info()
     * - muxing: filled by the caller before avformat_write_header()
     */
    public native AVCodecParameters codecpar(); public native AVStream codecpar(AVCodecParameters setter);

    /*****************************************************************
     * All fields below this line are not part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * Internal note: be aware that physically removing these fields
     * will break ABI. Replace removed fields with dummy fields, and
     * add new fields to AVStreamInternal.
     *****************************************************************
     */

public static final int MAX_STD_TIMEBASES = (30*12+30+3+6);
    /**
     * Stream information used internally by avformat_find_stream_info()
     */
        @Name({"info", ".last_dts"}) public native @Cast("int64_t") long info_last_dts(int i); public native AVStream info_last_dts(int i, long setter);
        @Name({"info", ".duration_gcd"}) public native @Cast("int64_t") long info_duration_gcd(int i); public native AVStream info_duration_gcd(int i, long setter);
        @Name({"info", ".duration_count"}) public native int info_duration_count(int i); public native AVStream info_duration_count(int i, int setter);
        @Name({"info", ".rfps_duration_sum"}) public native @Cast("int64_t") long info_rfps_duration_sum(int i); public native AVStream info_rfps_duration_sum(int i, long setter);
        @Name({"info", ".duration_error"}) @MemberGetter public native @Cast("double*") DoublePointer info_duration_error(int i);
        @Name({"info", ".codec_info_duration"}) public native @Cast("int64_t") long info_codec_info_duration(int i); public native AVStream info_codec_info_duration(int i, long setter);
        @Name({"info", ".codec_info_duration_fields"}) public native @Cast("int64_t") long info_codec_info_duration_fields(int i); public native AVStream info_codec_info_duration_fields(int i, long setter);
        @Name({"info", ".frame_delay_evidence"}) public native int info_frame_delay_evidence(int i); public native AVStream info_frame_delay_evidence(int i, int setter);

        /**
         * 0  -> decoder has not been searched for yet.
         * >0 -> decoder found
         * <0 -> decoder with codec_id == -found_decoder has not been found
         */
        @Name({"info", ".found_decoder"}) public native int info_found_decoder(int i); public native AVStream info_found_decoder(int i, int setter);

        @Name({"info", ".last_duration"}) public native @Cast("int64_t") long info_last_duration(int i); public native AVStream info_last_duration(int i, long setter);

        /**
         * Those are used for average framerate estimation.
         */
        @Name({"info", ".fps_first_dts"}) public native @Cast("int64_t") long info_fps_first_dts(int i); public native AVStream info_fps_first_dts(int i, long setter);
        @Name({"info", ".fps_first_dts_idx"}) public native int info_fps_first_dts_idx(int i); public native AVStream info_fps_first_dts_idx(int i, int setter);
        @Name({"info", ".fps_last_dts"}) public native @Cast("int64_t") long info_fps_last_dts(int i); public native AVStream info_fps_last_dts(int i, long setter);
        @Name({"info", ".fps_last_dts_idx"}) public native int info_fps_last_dts_idx(int i); public native AVStream info_fps_last_dts_idx(int i, int setter);

    /** number of bits in pts (used for wrapping control) */
    public native int pts_wrap_bits(); public native AVStream pts_wrap_bits(int setter);

    // Timestamp generation support:
    /**
     * Timestamp corresponding to the last dts sync point.
     *
     * Initialized when AVCodecParserContext.dts_sync_point >= 0 and
     * a DTS is received from the underlying container. Otherwise set to
     * AV_NOPTS_VALUE by default.
     */
    public native @Cast("int64_t") long first_dts(); public native AVStream first_dts(long setter);
    public native @Cast("int64_t") long cur_dts(); public native AVStream cur_dts(long setter);
    public native @Cast("int64_t") long last_IP_pts(); public native AVStream last_IP_pts(long setter);
    public native int last_IP_duration(); public native AVStream last_IP_duration(int setter);

    /**
     * Number of packets to buffer for codec probing
     */
    public native int probe_packets(); public native AVStream probe_packets(int setter);

    /**
     * Number of frames that have been demuxed during avformat_find_stream_info()
     */
    public native int codec_info_nb_frames(); public native AVStream codec_info_nb_frames(int setter);

    /* av_read_frame() support */
    public native @Cast("AVStreamParseType") int need_parsing(); public native AVStream need_parsing(int setter);
    public native AVCodecParserContext parser(); public native AVStream parser(AVCodecParserContext setter);

    /**
     * last packet in packet_buffer for this stream when muxing.
     */
    public native AVPacketList last_in_packet_buffer(); public native AVStream last_in_packet_buffer(AVPacketList setter);
    public native @ByRef AVProbeData probe_data(); public native AVStream probe_data(AVProbeData setter);
public static final int MAX_REORDER_DELAY = 16;
    public native @Cast("int64_t") long pts_buffer(int i); public native AVStream pts_buffer(int i, long setter);
    @MemberGetter public native @Cast("int64_t*") LongPointer pts_buffer();

    /** Only used if the format does not
                                        support seeking natively. */
    public native AVIndexEntry index_entries(); public native AVStream index_entries(AVIndexEntry setter);
    public native int nb_index_entries(); public native AVStream nb_index_entries(int setter);
    public native @Cast("unsigned int") int index_entries_allocated_size(); public native AVStream index_entries_allocated_size(int setter);

    /**
     * Stream Identifier
     * This is the MPEG-TS stream identifier +1
     * 0 means unknown
     */
    public native int stream_identifier(); public native AVStream stream_identifier(int setter);

    /**
     * Details of the MPEG-TS program which created this stream.
     */
    public native int program_num(); public native AVStream program_num(int setter);
    public native int pmt_version(); public native AVStream pmt_version(int setter);
    public native int pmt_stream_idx(); public native AVStream pmt_stream_idx(int setter);

    public native @Cast("int64_t") long interleaver_chunk_size(); public native AVStream interleaver_chunk_size(long setter);
    public native @Cast("int64_t") long interleaver_chunk_duration(); public native AVStream interleaver_chunk_duration(long setter);

    /**
     * stream probing state
     * -1   -> probing finished
     *  0   -> no probing requested
     * rest -> perform probing with request_probe being the minimum score to accept.
     */
    public native int request_probe(); public native AVStream request_probe(int setter);
    /**
     * Indicates that everything up to the next keyframe
     * should be discarded.
     */
    public native int skip_to_keyframe(); public native AVStream skip_to_keyframe(int setter);

    /**
     * Number of samples to skip at the start of the frame decoded from the next packet.
     */
    public native int skip_samples(); public native AVStream skip_samples(int setter);

    /**
     * If not 0, the number of samples that should be skipped from the start of
     * the stream (the samples are removed from packets with pts==0, which also
     * assumes negative timestamps do not happen).
     * Intended for use with formats such as mp3 with ad-hoc gapless audio
     * support.
     */
    public native @Cast("int64_t") long start_skip_samples(); public native AVStream start_skip_samples(long setter);

    /**
     * If not 0, the first audio sample that should be discarded from the stream.
     * This is broken by design (needs global sample count), but can't be
     * avoided for broken by design formats such as mp3 with ad-hoc gapless
     * audio support.
     */
    public native @Cast("int64_t") long first_discard_sample(); public native AVStream first_discard_sample(long setter);

    /**
     * The sample after last sample that is intended to be discarded after
     * first_discard_sample. Works on frame boundaries only. Used to prevent
     * early EOF if the gapless info is broken (considered concatenated mp3s).
     */
    public native @Cast("int64_t") long last_discard_sample(); public native AVStream last_discard_sample(long setter);

    /**
     * Number of internally decoded frames, used internally in libavformat, do not access
     * its lifetime differs from info which is why it is not in that structure.
     */
    public native int nb_decoded_frames(); public native AVStream nb_decoded_frames(int setter);

    /**
     * Timestamp offset added to timestamps before muxing
     */
    public native @Cast("int64_t") long mux_ts_offset(); public native AVStream mux_ts_offset(long setter);

    /**
     * Internal data to check for wrapping of the time stamp
     */
    public native @Cast("int64_t") long pts_wrap_reference(); public native AVStream pts_wrap_reference(long setter);

    /**
     * Options for behavior, when a wrap is detected.
     *
     * Defined by AV_PTS_WRAP_ values.
     *
     * If correction is enabled, there are two possibilities:
     * If the first time stamp is near the wrap point, the wrap offset
     * will be subtracted, which will create negative time stamps.
     * Otherwise the offset will be added.
     */
    public native int pts_wrap_behavior(); public native AVStream pts_wrap_behavior(int setter);

    /**
     * Internal data to prevent doing update_initial_durations() twice
     */
    public native int update_initial_durations_done(); public native AVStream update_initial_durations_done(int setter);

    /**
     * Internal data to generate dts from pts
     */
    public native @Cast("int64_t") long pts_reorder_error(int i); public native AVStream pts_reorder_error(int i, long setter);
    @MemberGetter public native @Cast("int64_t*") LongPointer pts_reorder_error();
    public native @Cast("uint8_t") byte pts_reorder_error_count(int i); public native AVStream pts_reorder_error_count(int i, byte setter);
    @MemberGetter public native @Cast("uint8_t*") BytePointer pts_reorder_error_count();

    /**
     * Internal data to analyze DTS and detect faulty mpeg streams
     */
    public native @Cast("int64_t") long last_dts_for_order_check(); public native AVStream last_dts_for_order_check(long setter);
    public native @Cast("uint8_t") byte dts_ordered(); public native AVStream dts_ordered(byte setter);
    public native @Cast("uint8_t") byte dts_misordered(); public native AVStream dts_misordered(byte setter);

    /**
     * Internal data to inject global side data
     */
    public native int inject_global_side_data(); public native AVStream inject_global_side_data(int setter);

    /**
     * display aspect ratio (0 if unknown)
     * - encoding: unused
     * - decoding: Set by libavformat to calculate sample_aspect_ratio internally
     */
    public native @ByRef AVRational display_aspect_ratio(); public native AVStream display_aspect_ratio(AVRational setter);

    /**
     * An opaque field for libavformat internal usage.
     * Must not be accessed in any way by callers.
     */
    public native AVStreamInternal internal(); public native AVStream internal(AVStreamInternal setter);
}
