/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.tensorflow;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.tensorflow.TF_Graph;
import org.bytedeco.tensorflow.TF_Session;
import org.bytedeco.tensorflow.TF_SessionOptions;
import org.bytedeco.tensorflow.TF_Status;
import org.bytedeco.tensorflow.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTF_Session
extends Pointer {
    protected TF_Graph graph;
    protected TF_SessionOptions opts;
    protected TF_Status status;

    public AbstractTF_Session(Pointer p) {
        super(p);
    }

    public static TF_Session newSession(TF_Graph graph, TF_SessionOptions opts, TF_Status status) {
        TF_Session s = org.bytedeco.tensorflow.global.tensorflow.TF_NewSession(graph, opts, status);
        if (s != null) {
            s.graph = graph;
            s.opts = opts;
            s.status = status;
            s.deallocator(new DeleteDeallocator(s));
        }
        return s;
    }

    public void delete() {
        this.deallocate();
    }

    protected static class DeleteDeallocator
    extends TF_Session
    implements Pointer.Deallocator {
        DeleteDeallocator(TF_Session s) {
            super(s);
        }

        public void deallocate() {
            if (!this.isNull()) {
                org.bytedeco.tensorflow.global.tensorflow.TF_DeleteSession(this, TF_Status.newStatus());
            }
            this.setNull();
        }
    }
}

