/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.tensorflow.lite.DataType;
import org.tensorflow.lite.TensorFlowLite;

public final class Tensor {
    private long nativeHandle;
    private final DataType dtype;
    private int[] shapeCopy;

    static Tensor fromIndex(long nativeInterpreterHandle, int tensorIndex) {
        return new Tensor(Tensor.create(nativeInterpreterHandle, tensorIndex));
    }

    void close() {
        Tensor.delete(this.nativeHandle);
        this.nativeHandle = 0L;
    }

    public DataType dataType() {
        return this.dtype;
    }

    public int numDimensions() {
        return this.shapeCopy.length;
    }

    public int numBytes() {
        return Tensor.numBytes(this.nativeHandle);
    }

    public int numElements() {
        return Tensor.computeNumElements(this.shapeCopy);
    }

    public int[] shape() {
        return this.shapeCopy;
    }

    void setTo(Object src) {
        this.throwExceptionIfTypeIsIncompatible(src);
        if (Tensor.isByteBuffer(src)) {
            ByteBuffer srcBuffer = (ByteBuffer)src;
            if (srcBuffer.isDirect() && srcBuffer.order() == ByteOrder.nativeOrder()) {
                Tensor.writeDirectBuffer(this.nativeHandle, srcBuffer);
            } else {
                this.buffer().put(srcBuffer);
            }
            return;
        }
        Tensor.writeMultiDimensionalArray(this.nativeHandle, src);
    }

    Object copyTo(Object dst) {
        this.throwExceptionIfTypeIsIncompatible(dst);
        if (dst instanceof ByteBuffer) {
            ByteBuffer dstByteBuffer = (ByteBuffer)dst;
            dstByteBuffer.put(this.buffer());
            return dst;
        }
        Tensor.readMultiDimensionalArray(this.nativeHandle, dst);
        return dst;
    }

    int[] getInputShapeIfDifferent(Object input) {
        if (Tensor.isByteBuffer(input)) {
            return null;
        }
        int[] inputShape = Tensor.computeShapeOf(input);
        if (Arrays.equals(this.shapeCopy, inputShape)) {
            return null;
        }
        return inputShape;
    }

    void refreshShape() {
        this.shapeCopy = Tensor.shape(this.nativeHandle);
    }

    static DataType dataTypeOf(Object o) {
        if (o != null) {
            Class<?> c = o.getClass();
            while (c.isArray()) {
                c = c.getComponentType();
            }
            if (Float.TYPE.equals(c)) {
                return DataType.FLOAT32;
            }
            if (Integer.TYPE.equals(c)) {
                return DataType.INT32;
            }
            if (Byte.TYPE.equals(c)) {
                return DataType.UINT8;
            }
            if (Long.TYPE.equals(c)) {
                return DataType.INT64;
            }
            if (String.class.equals(c)) {
                return DataType.STRING;
            }
        }
        throw new IllegalArgumentException("DataType error: cannot resolve DataType of " + o.getClass().getName());
    }

    static int[] computeShapeOf(Object o) {
        int size = Tensor.computeNumDimensions(o);
        int[] dimensions = new int[size];
        Tensor.fillShape(o, 0, dimensions);
        return dimensions;
    }

    static int computeNumElements(int[] shape) {
        int n = 1;
        for (int i = 0; i < shape.length; ++i) {
            n *= shape[i];
        }
        return n;
    }

    static int computeNumDimensions(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return 0;
        }
        if (Array.getLength(o) == 0) {
            throw new IllegalArgumentException("Array lengths cannot be 0.");
        }
        return 1 + Tensor.computeNumDimensions(Array.get(o, 0));
    }

    static void fillShape(Object o, int dim, int[] shape) {
        if (shape == null || dim == shape.length) {
            return;
        }
        int len = Array.getLength(o);
        if (shape[dim] == 0) {
            shape[dim] = len;
        } else if (shape[dim] != len) {
            throw new IllegalArgumentException(String.format("Mismatched lengths (%d and %d) in dimension %d", shape[dim], len, dim));
        }
        for (int i = 0; i < len; ++i) {
            Tensor.fillShape(Array.get(o, i), dim + 1, shape);
        }
    }

    private void throwExceptionIfTypeIsIncompatible(Object o) {
        if (Tensor.isByteBuffer(o)) {
            ByteBuffer oBuffer = (ByteBuffer)o;
            if (oBuffer.capacity() != this.numBytes()) {
                throw new IllegalArgumentException(String.format("Cannot convert between a TensorFlowLite buffer with %d bytes and a ByteBuffer with %d bytes.", this.numBytes(), oBuffer.capacity()));
            }
            return;
        }
        DataType oType = Tensor.dataTypeOf(o);
        if (oType != this.dtype) {
            throw new IllegalArgumentException(String.format("Cannot convert between a TensorFlowLite tensor with type %s and a Java object of type %s (which is compatible with the TensorFlowLite type %s).", new Object[]{this.dtype, o.getClass().getName(), oType}));
        }
        int[] oShape = Tensor.computeShapeOf(o);
        if (!Arrays.equals(oShape, this.shapeCopy)) {
            throw new IllegalArgumentException(String.format("Cannot copy between a TensorFlowLite tensor with shape %s and a Java object with shape %s.", Arrays.toString(this.shapeCopy), Arrays.toString(oShape)));
        }
    }

    private static boolean isByteBuffer(Object o) {
        return o instanceof ByteBuffer;
    }

    private Tensor(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.dtype = DataType.fromC(Tensor.dtype(nativeHandle));
        this.shapeCopy = Tensor.shape(nativeHandle);
    }

    private ByteBuffer buffer() {
        return Tensor.buffer(this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private static native long create(long var0, int var2);

    private static native void delete(long var0);

    private static native ByteBuffer buffer(long var0);

    private static native void writeDirectBuffer(long var0, ByteBuffer var2);

    private static native int dtype(long var0);

    private static native int[] shape(long var0);

    private static native int numBytes(long var0);

    private static native void readMultiDimensionalArray(long var0, Object var2);

    private static native void writeMultiDimensionalArray(long var0, Object var2);

    static {
        TensorFlowLite.init();
    }
}

