/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Conv2DBackpropInput<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> Conv2DBackpropInput<T> create(Scope scope, Operand<Integer> inputSizes, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Conv2DBackpropInput", scope.makeOpName("Conv2DBackpropInput"));
        opBuilder.addInput(inputSizes.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useCudnnOnGpu != null) {
                    opBuilder.setAttr("use_cudnn_on_gpu", opts.useCudnnOnGpu);
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = (Long)opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new Conv2DBackpropInput<T>(opBuilder.build());
    }

    public static Options useCudnnOnGpu(Boolean useCudnnOnGpu) {
        return new Options().useCudnnOnGpu(useCudnnOnGpu);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Conv2DBackpropInput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean useCudnnOnGpu;
        private String dataFormat;
        private List<Long> dilations;

        public Options useCudnnOnGpu(Boolean useCudnnOnGpu) {
            this.useCudnnOnGpu = useCudnnOnGpu;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

