/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DepthwiseConv2dNativeBackpropFilter<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> DepthwiseConv2dNativeBackpropFilter<T> create(Scope scope, Operand<T> input, Operand<Integer> filterSizes, Operand<T> outBackprop, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DepthwiseConv2dNativeBackpropFilter", scope.makeOpName("DepthwiseConv2dNativeBackpropFilter"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filterSizes.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (int i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = (Long)opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new DepthwiseConv2dNativeBackpropFilter<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private DepthwiseConv2dNativeBackpropFilter(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String dataFormat;
        private List<Long> dilations;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

