/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Dilation2DBackpropFilter<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> filterBackprop;

    public static <T extends Number> Dilation2DBackpropFilter<T> create(Scope scope, Operand<T> input, Operand<T> filter, Operand<T> outBackprop, List<Long> strides, List<Long> rates, String padding) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Dilation2DBackpropFilter", scope.makeOpName("Dilation2DBackpropFilter"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        long[] ratesArray = new long[rates.size()];
        for (int i = 0; i < ratesArray.length; ++i) {
            ratesArray[i] = rates.get(i);
        }
        opBuilder.setAttr("rates", ratesArray);
        opBuilder.setAttr("padding", padding);
        return new Dilation2DBackpropFilter<T>(opBuilder.build());
    }

    public Output<T> filterBackprop() {
        return this.filterBackprop;
    }

    @Override
    public Output<T> asOutput() {
        return this.filterBackprop;
    }

    private Dilation2DBackpropFilter(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.filterBackprop = operation.output(outputIdx++);
    }
}

