/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class FusedBatchNormGrad<T extends Number>
extends PrimitiveOp {
    private Output<T> xBackprop;
    private Output<T> scaleBackprop;
    private Output<T> offsetBackprop;
    private Output<T> reserveSpace3;
    private Output<T> reserveSpace4;

    public static <T extends Number> FusedBatchNormGrad<T> create(Scope scope, Operand<T> yBackprop, Operand<T> x, Operand<T> scale, Operand<T> reserveSpace1, Operand<T> reserveSpace2, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("FusedBatchNormGrad", scope.makeOpName("FusedBatchNormGrad"));
        opBuilder.addInput(yBackprop.asOutput());
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(reserveSpace1.asOutput());
        opBuilder.addInput(reserveSpace2.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.epsilon != null) {
                    opBuilder.setAttr("epsilon", opts.epsilon.floatValue());
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.isTraining == null) continue;
                opBuilder.setAttr("is_training", opts.isTraining);
            }
        }
        return new FusedBatchNormGrad<T>(opBuilder.build());
    }

    public static Options epsilon(Float epsilon) {
        return new Options().epsilon(epsilon);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options isTraining(Boolean isTraining) {
        return new Options().isTraining(isTraining);
    }

    public Output<T> xBackprop() {
        return this.xBackprop;
    }

    public Output<T> scaleBackprop() {
        return this.scaleBackprop;
    }

    public Output<T> offsetBackprop() {
        return this.offsetBackprop;
    }

    public Output<T> reserveSpace3() {
        return this.reserveSpace3;
    }

    public Output<T> reserveSpace4() {
        return this.reserveSpace4;
    }

    private FusedBatchNormGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.xBackprop = operation.output(outputIdx++);
        this.scaleBackprop = operation.output(outputIdx++);
        this.offsetBackprop = operation.output(outputIdx++);
        this.reserveSpace3 = operation.output(outputIdx++);
        this.reserveSpace4 = operation.output(outputIdx++);
    }

    public static class Options {
        private Float epsilon;
        private String dataFormat;
        private Boolean isTraining;

        public Options epsilon(Float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options isTraining(Boolean isTraining) {
            this.isTraining = isTraining;
            return this;
        }

        private Options() {
        }
    }
}

