/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LeakyRelu<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> activations;

    public static <T extends Number> LeakyRelu<T> create(Scope scope, Operand<T> features, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("LeakyRelu", scope.makeOpName("LeakyRelu"));
        opBuilder.addInput(features.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alpha == null) continue;
                opBuilder.setAttr("alpha", opts.alpha.floatValue());
            }
        }
        return new LeakyRelu<T>(opBuilder.build());
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public Output<T> activations() {
        return this.activations;
    }

    @Override
    public Output<T> asOutput() {
        return this.activations;
    }

    private LeakyRelu(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.activations = operation.output(outputIdx++);
    }

    public static class Options {
        private Float alpha;

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        private Options() {
        }
    }
}

