/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LoadAndRemapMatrix
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> outputMatrix;

    public static LoadAndRemapMatrix create(Scope scope, Operand<String> ckptPath, Operand<String> oldTensorName, Operand<Long> rowRemapping, Operand<Long> colRemapping, Operand<Float> initializingValues, Long numRows, Long numCols, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("LoadAndRemapMatrix", scope.makeOpName("LoadAndRemapMatrix"));
        opBuilder.addInput(ckptPath.asOutput());
        opBuilder.addInput(oldTensorName.asOutput());
        opBuilder.addInput(rowRemapping.asOutput());
        opBuilder.addInput(colRemapping.asOutput());
        opBuilder.addInput(initializingValues.asOutput());
        opBuilder.setAttr("num_rows", numRows);
        opBuilder.setAttr("num_cols", numCols);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxRowsInMemory == null) continue;
                opBuilder.setAttr("max_rows_in_memory", opts.maxRowsInMemory);
            }
        }
        return new LoadAndRemapMatrix(opBuilder.build());
    }

    public static Options maxRowsInMemory(Long maxRowsInMemory) {
        return new Options().maxRowsInMemory(maxRowsInMemory);
    }

    public Output<Float> outputMatrix() {
        return this.outputMatrix;
    }

    @Override
    public Output<Float> asOutput() {
        return this.outputMatrix;
    }

    private LoadAndRemapMatrix(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.outputMatrix = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxRowsInMemory;

        public Options maxRowsInMemory(Long maxRowsInMemory) {
            this.maxRowsInMemory = maxRowsInMemory;
            return this;
        }

        private Options() {
        }
    }
}

