/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Print<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> Print<T> create(Scope scope, Operand<T> input, Iterable<Operand<?>> data, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Print", scope.makeOpName("Print"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInputList(Operands.asOutputs(data));
        if (options != null) {
            for (Options opts : options) {
                if (opts.message != null) {
                    opBuilder.setAttr("message", opts.message);
                }
                if (opts.firstN != null) {
                    opBuilder.setAttr("first_n", opts.firstN);
                }
                if (opts.summarize == null) continue;
                opBuilder.setAttr("summarize", opts.summarize);
            }
        }
        return new Print<T>(opBuilder.build());
    }

    public static Options message(String message) {
        return new Options().message(message);
    }

    public static Options firstN(Long firstN) {
        return new Options().firstN(firstN);
    }

    public static Options summarize(Long summarize) {
        return new Options().summarize(summarize);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Print(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String message;
        private Long firstN;
        private Long summarize;

        public Options message(String message) {
            this.message = message;
            return this;
        }

        public Options firstN(Long firstN) {
            this.firstN = firstN;
            return this;
        }

        public Options summarize(Long summarize) {
            this.summarize = summarize;
            return this;
        }

        private Options() {
        }
    }
}

