/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RaggedGather<T>
extends PrimitiveOp {
    private List<Output<Long>> outputNestedSplits;
    private Output<T> outputDenseValues;

    public static <T, U extends Number> RaggedGather<T> create(Scope scope, Iterable<Operand<Long>> paramsNestedSplits, Operand<T> paramsDenseValues, Operand<U> indices, Long OUTPUTRAGGEDRANK) {
        OperationBuilder opBuilder = scope.graph().opBuilder("RaggedGather", scope.makeOpName("RaggedGather"));
        opBuilder.addInputList(Operands.asOutputs(paramsNestedSplits));
        opBuilder.addInput(paramsDenseValues.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.setAttr("OUTPUT_RAGGED_RANK", OUTPUTRAGGEDRANK);
        return new RaggedGather<T>(opBuilder.build());
    }

    public List<Output<Long>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<T> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedGather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }
}

