/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseReduceSum<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> SparseReduceSum<T> create(Scope scope, Operand<Long> inputIndices, Operand<T> inputValues, Operand<Long> inputShape, Operand<Integer> reductionAxes, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("SparseReduceSum", scope.makeOpName("SparseReduceSum"));
        opBuilder.addInput(inputIndices.asOutput());
        opBuilder.addInput(inputValues.asOutput());
        opBuilder.addInput(inputShape.asOutput());
        opBuilder.addInput(reductionAxes.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.keepDims == null) continue;
                opBuilder.setAttr("keep_dims", opts.keepDims);
            }
        }
        return new SparseReduceSum<T>(opBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private SparseReduceSum(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

