/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.processor;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public final class OperatorProcessor
extends AbstractProcessor {
    private static final Pattern JAVADOC_TAG_PATTERN = Pattern.compile("@(?:param|return|throws|exception|see)\\s+.*");
    private static final TypeName T_OPS = ClassName.get((String)"org.tensorflow.op", (String)"Ops", (String[])new String[0]);
    private static final TypeName T_OPERATOR = ClassName.get((String)"org.tensorflow.op.annotation", (String)"Operator", (String[])new String[0]);
    private static final TypeName T_SCOPE = ClassName.get((String)"org.tensorflow.op", (String)"Scope", (String[])new String[0]);
    private static final TypeName T_GRAPH = ClassName.get((String)"org.tensorflow", (String)"Graph", (String[])new String[0]);
    private static final TypeName T_STRING = ClassName.get(String.class);
    private Filer filer;
    private Messager messager;
    private Elements elements;
    private boolean hasRun = false;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (annotations.size() == 0) {
            return false;
        }
        if (annotations.size() != 1) {
            throw new IllegalStateException("Unexpected - multiple annotations registered: " + annotations);
        }
        TypeElement annotation = annotations.iterator().next();
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(annotation);
        if (annotated.size() == 0) {
            return true;
        }
        if (this.hasRun) {
            for (Element element : annotated) {
                this.error(element, "The Operator processor has already processed @Operator annotated sources\nand written out an Ops API. It cannot process additional @Operator sources.\nOne reason this can happen is if other annotation processors generate\nnew @Operator source files.", new Object[0]);
            }
            return true;
        }
        HashMultimap groupedMethods = HashMultimap.create();
        if (!this.collectOpsMethods(roundEnv, (Multimap<String, MethodSpec>)groupedMethods, annotation)) {
            return true;
        }
        if (groupedMethods.isEmpty()) {
            return true;
        }
        this.writeApi((Multimap<String, MethodSpec>)groupedMethods);
        this.hasRun = true;
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("org.tensorflow.op.annotation.Operator");
    }

    private void error(Element e, String message, Object ... args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, e);
    }

    private void write(TypeSpec spec) {
        try {
            JavaFile.builder((String)"org.tensorflow.op", (TypeSpec)spec).skipJavaLangImports(true).build().writeTo(this.filer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void writeApi(Multimap<String, MethodSpec> groupedMethods) {
        HashMap<String, ClassName> groups = new HashMap<String, ClassName>();
        for (Map.Entry entry : groupedMethods.asMap().entrySet()) {
            if (((String)entry.getKey()).isEmpty()) continue;
            TypeSpec groupClass = OperatorProcessor.buildGroupClass((String)entry.getKey(), (Collection)entry.getValue());
            this.write(groupClass);
            groups.put((String)entry.getKey(), ClassName.get((String)"org.tensorflow.op", (String)groupClass.name, (String[])new String[0]));
        }
        TypeSpec topClass = OperatorProcessor.buildTopClass(groups, groupedMethods.get((Object)""));
        this.write(topClass);
    }

    private boolean collectOpsMethods(RoundEnvironment roundEnv, Multimap<String, MethodSpec> groupedMethods, TypeElement annotation) {
        boolean result = true;
        for (Element element : roundEnv.getElementsAnnotatedWith(annotation)) {
            if (!(element instanceof TypeElement)) {
                this.error(element, "@Operator can only be applied to classes, but this is a %s", element.getKind().toString());
                result = false;
                continue;
            }
            TypeElement opClass = (TypeElement)element;
            if (opClass.getAnnotation(Deprecated.class) != null) continue;
            this.collectOpMethods(groupedMethods, opClass, annotation);
        }
        return result;
    }

    private void collectOpMethods(Multimap<String, MethodSpec> groupedMethods, TypeElement opClass, TypeElement annotation) {
        AnnotationMirror am = OperatorProcessor.getAnnotationMirror(opClass, annotation);
        String groupName = OperatorProcessor.getAnnotationElementValueAsString("group", am);
        String methodName = OperatorProcessor.getAnnotationElementValueAsString("name", am);
        ClassName opClassName = ClassName.get((TypeElement)opClass);
        if (Strings.isNullOrEmpty((String)methodName)) {
            methodName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, opClassName.simpleName());
        }
        for (ExecutableElement opMethod : ElementFilter.methodsIn(opClass.getEnclosedElements())) {
            if (!opMethod.getModifiers().contains((Object)Modifier.STATIC) || !opMethod.getSimpleName().contentEquals("create")) continue;
            MethodSpec method = this.buildOpMethod(methodName, opClassName, opMethod);
            groupedMethods.put((Object)groupName, (Object)method);
        }
    }

    private MethodSpec buildOpMethod(String methodName, ClassName opClassName, ExecutableElement factoryMethod) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)factoryMethod.getReturnType())).varargs(factoryMethod.isVarArgs()).addJavadoc("$L", new Object[]{this.buildOpMethodJavadoc(opClassName, factoryMethod)});
        for (TypeParameterElement typeParameterElement : factoryMethod.getTypeParameters()) {
            TypeVariableName tvn = TypeVariableName.get((TypeVariable)((TypeVariable)typeParameterElement.asType()));
            builder.addTypeVariable(tvn);
        }
        for (TypeMirror typeMirror : factoryMethod.getThrownTypes()) {
            builder.addException(TypeName.get((TypeMirror)typeMirror));
        }
        StringBuilder call = new StringBuilder("return $T.create(scope");
        boolean bl = true;
        for (VariableElement variableElement : factoryMethod.getParameters()) {
            boolean bl2;
            ParameterSpec p = ParameterSpec.get((VariableElement)variableElement);
            if (bl2) {
                bl2 = false;
                continue;
            }
            call.append(", ");
            call.append(p.name);
            builder.addParameter(p);
        }
        call.append(")");
        builder.addStatement(call.toString(), new Object[]{opClassName});
        return builder.build();
    }

    private String buildOpMethodJavadoc(ClassName opClassName, ExecutableElement factoryMethod) {
        StringBuilder javadoc = new StringBuilder();
        javadoc.append("Adds an {@link ").append(opClassName.simpleName()).append("} operation to the graph\n\n");
        Matcher tagMatcher = JAVADOC_TAG_PATTERN.matcher(this.elements.getDocComment(factoryMethod));
        boolean firstParam = true;
        while (tagMatcher.find()) {
            String tag = tagMatcher.group();
            if (tag.startsWith("@param") && firstParam) {
                firstParam = false;
                continue;
            }
            javadoc.append(tag).append('\n');
        }
        javadoc.append("@see ").append(opClassName).append("\n");
        return javadoc.toString();
    }

    private static TypeSpec buildGroupClass(String group, Collection<MethodSpec> methods) {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addParameter(T_SCOPE, "scope", new Modifier[0]).addStatement("this.scope = scope", new Object[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, group) + "Ops")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("An API for adding {@code $L} operations to a {@link $T Graph}\n\n@see {@link $T}\n", new Object[]{group, T_GRAPH, T_OPS}).addMethods(methods).addMethod(ctorBuilder.build());
        builder.addField(FieldSpec.builder((TypeName)T_SCOPE, (String)"scope", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        return builder.build();
    }

    private static TypeSpec buildTopClass(Map<String, ClassName> groupToClass, Collection<MethodSpec> methods) {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(T_SCOPE, "scope", new Modifier[0]).addStatement("this.scope = scope", new Object[]{T_SCOPE});
        for (Map.Entry<String, ClassName> entry : groupToClass.entrySet()) {
            ctorBuilder.addStatement("$L = new $T(scope)", new Object[]{entry.getKey(), entry.getValue()});
        }
        TypeSpec.Builder opsBuilder = TypeSpec.classBuilder((String)"Ops").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("An API for building a {@link $T} with operation wrappers\n<p>\nAny operation wrapper found in the classpath properly annotated as an{@link $T @Operator} is exposed\nby this API or one of its subgroup.\n<p>Example usage:\n<pre>{@code\ntry (Graph g = new Graph()) {\n  Ops ops = new Ops(g);\n  // Operations are typed classes with convenience\n  // builders in Ops.\n  Constant three = ops.constant(3);\n  // Single-result operations implement the Operand\n  // interface, so this works too.\n  Operand four = ops.constant(4);\n  // Most builders are found within a group, and accept\n  // Operand types as operands\n  Operand nine = ops.math().add(four, ops.constant(5));\n  // Multi-result operations however offer methods to\n  // select a particular result for use.\n  Operand result = \n      ops.math().add(ops.array().unique(s, a).y(), b);\n  // Optional attributes\n  ops.math().matMul(a, b, MatMul.transposeA(true));\n  // Naming operators\n  // Names can exist in a hierarchy\n}\n}</pre>\n", new Object[]{T_GRAPH, T_OPERATOR}).addMethods(methods).addMethod(ctorBuilder.build());
        opsBuilder.addMethod(MethodSpec.methodBuilder((String)"withSubScope").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(T_STRING, "childScopeName", new Modifier[0]).returns(T_OPS).addStatement("return new $T(scope.withSubScope(childScopeName))", new Object[]{T_OPS}).addJavadoc("Returns an API that adds operations to the graph with the provided name prefix.\n\n@see {@link $T#withSubScope(String)}\n", new Object[]{T_SCOPE}).build());
        opsBuilder.addMethod(MethodSpec.methodBuilder((String)"withName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(T_STRING, "opName", new Modifier[0]).returns(T_OPS).addStatement("return new Ops(scope.withName(opName))", new Object[0]).addJavadoc("Returns an API that uses the provided name for an op.\n\n@see {@link $T#withName(String)}\n", new Object[]{T_SCOPE}).build());
        opsBuilder.addField(FieldSpec.builder((TypeName)T_SCOPE, (String)"scope", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
        opsBuilder.addMethod(MethodSpec.methodBuilder((String)"scope").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(T_SCOPE).addStatement("return scope", new Object[0]).addJavadoc("Returns the current {@link $T scope} of this API\n", new Object[]{T_SCOPE}).build());
        for (Map.Entry<String, ClassName> entry : groupToClass.entrySet()) {
            opsBuilder.addField(FieldSpec.builder((TypeName)((TypeName)entry.getValue()), (String)entry.getKey(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).build());
            opsBuilder.addMethod(MethodSpec.methodBuilder((String)entry.getKey()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)entry.getValue()).addStatement("return $L", new Object[]{entry.getKey()}).addJavadoc("Returns an API for adding {@code $L} operations to the graph\n", new Object[]{entry.getKey()}).build());
        }
        opsBuilder.addMethod(MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(T_GRAPH, "graph", new Modifier[0]).returns(T_OPS).addStatement("return new Ops(new $T(graph))", new Object[]{T_SCOPE}).addJavadoc("Creates an API for adding operations to the provided {@code graph}\n", new Object[0]).build());
        return opsBuilder.build();
    }

    private static AnnotationMirror getAnnotationMirror(Element element, TypeElement annotation) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(annotation)) continue;
            return annotationMirror;
        }
        throw new IllegalArgumentException("Annotation " + annotation.getSimpleName() + " not present on element " + element.getSimpleName());
    }

    private static String getAnnotationElementValueAsString(String elementName, AnnotationMirror am) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(elementName)) continue;
            return entry.getValue().getValue().toString();
        }
        return "";
    }
}

