/*
 * Copyright © 2012 - 2018 camunda services GmbH and various authors (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.camunda.bpm.engine.rest.sub.repository;

import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.camunda.bpm.engine.rest.dto.repository.DeploymentResourceDto;

/**
 * @author Sebastian Menski
 */
public interface DeploymentResourcesResource {

  @GET
  @Produces(MediaType.APPLICATION_JSON)
  List<DeploymentResourceDto> getDeploymentResources();

  @GET
  @Path("/{resourceId}")
  @Produces(MediaType.APPLICATION_JSON)
  DeploymentResourceDto getDeploymentResource(@PathParam("resourceId") String resourceId);

  @GET
  @Path("/{resourceId}/data")
  Response getDeploymentResourceData(@PathParam("resourceId") String resourceId);

}
