/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricDecisionInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.history.batch.DeleteHistoricDecisionInstancesDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.history.HistoricDecisionInstanceRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricDecisionInstanceResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricDecisionInstanceResourceImpl;

public class HistoricDecisionInstanceRestServiceImpl
implements HistoricDecisionInstanceRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricDecisionInstanceRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricDecisionInstanceResource getHistoricDecisionInstance(String decisionInstanceId) {
        return new HistoricDecisionInstanceResourceImpl(this.processEngine, decisionInstanceId);
    }

    @Override
    public List<HistoricDecisionInstanceDto> getHistoricDecisionInstances(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricDecisionInstanceQueryDto queryHistoricDecisionInstanceDto = new HistoricDecisionInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricDecisionInstances(queryHistoricDecisionInstanceDto, firstResult, maxResults);
    }

    public List<HistoricDecisionInstanceDto> queryHistoricDecisionInstances(HistoricDecisionInstanceQueryDto queryDto, Integer firstResult, Integer maxResults) {
        HistoricDecisionInstanceQuery query = (HistoricDecisionInstanceQuery)queryDto.toQuery(this.processEngine);
        List<HistoricDecisionInstance> matchingHistoricDecisionInstances = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<HistoricDecisionInstanceDto> historicDecisionInstanceDtoResults = new ArrayList<HistoricDecisionInstanceDto>();
        for (HistoricDecisionInstance historicDecisionInstance : matchingHistoricDecisionInstances) {
            HistoricDecisionInstanceDto resultHistoricDecisionInstanceDto = HistoricDecisionInstanceDto.fromHistoricDecisionInstance(historicDecisionInstance);
            historicDecisionInstanceDtoResults.add(resultHistoricDecisionInstanceDto);
        }
        return historicDecisionInstanceDtoResults;
    }

    private List<HistoricDecisionInstance> executePaginatedQuery(HistoricDecisionInstanceQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getHistoricDecisionInstancesCount(UriInfo uriInfo) {
        HistoricDecisionInstanceQueryDto queryDto = new HistoricDecisionInstanceQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricDecisionInstancesCount(queryDto);
    }

    public CountResultDto queryHistoricDecisionInstancesCount(HistoricDecisionInstanceQueryDto queryDto) {
        HistoricDecisionInstanceQuery query = (HistoricDecisionInstanceQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        return new CountResultDto(count);
    }

    @Override
    public BatchDto deleteAsync(DeleteHistoricDecisionInstancesDto dto) {
        HistoricDecisionInstanceQuery decisionInstanceQuery = null;
        if (dto.getHistoricDecisionInstanceQuery() != null) {
            decisionInstanceQuery = (HistoricDecisionInstanceQuery)dto.getHistoricDecisionInstanceQuery().toQuery(this.processEngine);
        }
        try {
            List<String> historicDecisionInstanceIds = dto.getHistoricDecisionInstanceIds();
            String deleteReason = dto.getDeleteReason();
            Batch batch = this.processEngine.getHistoryService().deleteHistoricDecisionInstancesAsync(historicDecisionInstanceIds, decisionInstanceQuery, deleteReason);
            return BatchDto.fromBatch(batch);
        }
        catch (BadUserRequestException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, e.getMessage());
        }
    }
}

