/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.jobexecutor.historycleanup.BatchWindow;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.dto.history.HistoryCleanupConfigurationDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.history.HistoryCleanupRestService;
import org.camunda.bpm.engine.runtime.Job;

public class HistoryCleanupRestServiceImpl
implements HistoryCleanupRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoryCleanupRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public JobDto cleanupAsync(boolean immediatelyDue) {
        Job job = this.processEngine.getHistoryService().cleanUpHistoryAsync(immediatelyDue);
        return JobDto.fromJob(job);
    }

    @Override
    public JobDto findCleanupJob() {
        Job job = this.processEngine.getHistoryService().findHistoryCleanupJob();
        if (job == null) {
            throw new RestException(Response.Status.NOT_FOUND, "History cleanup job does not exist");
        }
        return JobDto.fromJob(job);
    }

    @Override
    public List<JobDto> findCleanupJobs() {
        List jobs = this.processEngine.getHistoryService().findHistoryCleanupJobs();
        if (jobs == null || jobs.isEmpty()) {
            throw new RestException(Response.Status.NOT_FOUND, "History cleanup jobs are empty");
        }
        ArrayList<JobDto> dtos = new ArrayList<JobDto>();
        for (Job job : jobs) {
            JobDto dto = JobDto.fromJob(job);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public HistoryCleanupConfigurationDto getHistoryCleanupConfiguration() {
        HistoryCleanupConfigurationDto configurationDto = new HistoryCleanupConfigurationDto();
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        Date now = ClockUtil.getCurrentTime();
        BatchWindow batchWindow = processEngineConfiguration.getBatchWindowManager().getCurrentOrNextBatchWindow(now, processEngineConfiguration);
        if (batchWindow == null) {
            return configurationDto;
        }
        configurationDto.setBatchWindowStartTime(batchWindow.getStart());
        configurationDto.setBatchWindowEndTime(batchWindow.getEnd());
        return configurationDto;
    }
}

