/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.camunda.bpm.engine.impl.cmd.LicenseCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyManager;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceManager;

public class DeleteLicenseKeyCmd
extends LicenseCmd
implements Command<Object> {
    boolean deleteProperty;

    public DeleteLicenseKeyCmd(boolean deleteProperty) {
        this.deleteProperty = deleteProperty;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkCamundaAdmin();
        ResourceManager resourceManager = commandContext.getResourceManager();
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity licenseProperty = propertyManager.findPropertyById("camunda-license-key-id");
        ResourceEntity licenseKey = resourceManager.findLicenseKeyResource();
        if (licenseKey != null) {
            resourceManager.delete(licenseKey);
        }
        new DeletePropertyCmd("camunda-license-key").execute(commandContext);
        if (this.deleteProperty) {
            new DeletePropertyCmd("camunda-license-key-id").execute(commandContext);
        }
        return null;
    }
}

