/*
 * Decompiled with CFR 0.152.
 */
package camundajar.impl.com.cronutils.parser;

import camundajar.impl.com.cronutils.model.field.CronField;
import camundajar.impl.com.cronutils.model.field.CronFieldName;
import camundajar.impl.com.cronutils.model.field.constraint.FieldConstraints;
import camundajar.impl.com.cronutils.parser.FieldParser;
import camundajar.impl.com.cronutils.utils.Preconditions;
import java.util.Comparator;

public class CronParserField {
    private final CronFieldName field;
    private final FieldConstraints constraints;
    private final FieldParser parser;
    private final boolean optional;

    public CronParserField(CronFieldName fieldName, FieldConstraints constraints) {
        this(fieldName, constraints, false);
    }

    public CronParserField(CronFieldName fieldName, FieldConstraints constraints, boolean optional) {
        this.field = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
        this.parser = new FieldParser(constraints);
        this.optional = optional;
    }

    public CronFieldName getField() {
        return this.field;
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public CronField parse(String expression) {
        Integer value;
        String newExpression = expression;
        if (this.getField().equals((Object)CronFieldName.DAY_OF_WEEK) && newExpression.endsWith("L") && (value = this.constraints.getStringMappingValue(newExpression.substring(0, newExpression.length() - 1))) != null) {
            newExpression = value + "L";
        }
        return new CronField(this.field, this.parser.parse(newExpression), this.constraints);
    }

    public static Comparator<CronParserField> createFieldTypeComparator() {
        return Comparator.comparingInt(o -> o.getField().getOrder());
    }

    public String toString() {
        return "CronParserField{field=" + (Object)((Object)this.field) + '}';
    }
}

