/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.SignalEventReceivedCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.SignalEventReceivedBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class SignalEventReceivedBuilderImpl
implements SignalEventReceivedBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected final String signalName;
    protected String executionId = null;
    protected String tenantId = null;
    protected boolean isTenantIdSet = false;
    protected VariableMap variables = null;

    public SignalEventReceivedBuilderImpl(CommandExecutor commandExecutor, String signalName) {
        this.commandExecutor = commandExecutor;
        this.signalName = signalName;
    }

    @Override
    public SignalEventReceivedBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            if (this.variables == null) {
                this.variables = new VariableMapImpl();
            }
            this.variables.putAll(variables);
        }
        return this;
    }

    @Override
    public SignalEventReceivedBuilder executionId(String executionId) {
        EnsureUtil.ensureNotNull("executionId", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public SignalEventReceivedBuilder tenantId(String tenantId) {
        EnsureUtil.ensureNotNull("The tenant-id cannot be null. Use 'withoutTenantId()' if you want to send the signal to a process definition or an execution which has no tenant-id.", "tenantId", (Object)tenantId);
        this.tenantId = tenantId;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public SignalEventReceivedBuilder withoutTenantId() {
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public void send() {
        if (this.executionId != null && this.isTenantIdSet) {
            throw LOG.exceptionDeliverSignalToSingleExecutionWithTenantId();
        }
        SignalEventReceivedCmd command = new SignalEventReceivedCmd(this);
        this.commandExecutor.execute(command);
    }

    public String getSignalName() {
        return this.signalName;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }

    public VariableMap getVariables() {
        return this.variables;
    }
}

