/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.identity.db;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.IdentityOperationResult;
import org.camunda.bpm.engine.impl.identity.IndentityLogger;
import org.camunda.bpm.engine.impl.identity.WritableIdentityProvider;
import org.camunda.bpm.engine.impl.identity.db.DbReadOnlyIdentityServiceProvider;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantMembershipEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DbIdentityServiceProvider
extends DbReadOnlyIdentityServiceProvider
implements WritableIdentityProvider {
    protected static final IndentityLogger LOG = ProcessEngineLogger.INDENTITY_LOGGER;

    @Override
    public UserEntity createNewUser(String userId) {
        return new UserEntity(userId);
    }

    @Override
    public IdentityOperationResult saveUser(User user) {
        UserEntity userEntity = (UserEntity)user;
        userEntity.encryptPassword();
        String operation = null;
        if (userEntity.getRevision() == 0) {
            operation = "create";
            this.checkAuthorization(Permissions.CREATE, Resources.USER, null);
            this.getDbEntityManager().insert(userEntity);
            this.createDefaultAuthorizations(userEntity);
        } else {
            operation = "update";
            this.checkAuthorization(Permissions.UPDATE, Resources.USER, user.getId());
            this.getDbEntityManager().merge(userEntity);
        }
        return new IdentityOperationResult(userEntity, operation);
    }

    @Override
    public IdentityOperationResult deleteUser(final String userId) {
        this.checkAuthorization(Permissions.DELETE, Resources.USER, userId);
        UserEntity user = this.findUserById(userId);
        if (user != null) {
            this.deleteMembershipsByUserId(userId);
            this.deleteTenantMembershipsOfUser(userId);
            this.deleteAuthorizations(Resources.USER, userId);
            Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    List tenants = DbIdentityServiceProvider.this.createTenantQuery().userMember(userId).list();
                    if (tenants != null && !tenants.isEmpty()) {
                        for (Tenant tenant : tenants) {
                            DbIdentityServiceProvider.this.deleteAuthorizationsForUser(Resources.TENANT, tenant.getId(), userId);
                        }
                    }
                    return null;
                }
            });
            this.getDbEntityManager().delete(user);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    @Override
    public boolean checkPassword(String userId, String password) {
        UserEntity user = this.findUserById(userId);
        if (user == null || password == null) {
            return false;
        }
        if (this.isUserLocked(user)) {
            return false;
        }
        if (this.matchPassword(password, user)) {
            this.unlockUser(user);
            return true;
        }
        this.lockUser(user);
        return false;
    }

    protected boolean isUserLocked(UserEntity user) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int maxAttempts = processEngineConfiguration.getLoginMaxAttempts();
        int attempts = user.getAttempts();
        if (attempts >= maxAttempts) {
            return true;
        }
        Date lockExpirationTime = user.getLockExpirationTime();
        Date currentTime = ClockUtil.getCurrentTime();
        return lockExpirationTime != null && lockExpirationTime.after(currentTime);
    }

    protected void lockUser(UserEntity user) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int max = processEngineConfiguration.getLoginDelayMaxTime();
        int baseTime = processEngineConfiguration.getLoginDelayBase();
        int factor = processEngineConfiguration.getLoginDelayFactor();
        int attempts = user.getAttempts() + 1;
        long delay = (long)((double)baseTime * Math.pow(factor, attempts - 1));
        delay = Math.min(delay, (long)max) * 1000L;
        long currentTime = ClockUtil.getCurrentTime().getTime();
        Date lockExpirationTime = new Date(currentTime + delay);
        if (attempts >= processEngineConfiguration.getLoginMaxAttempts()) {
            LOG.infoUserPermanentlyLocked(user.getId());
        } else {
            LOG.infoUserTemporarilyLocked(user.getId(), lockExpirationTime);
        }
        this.getIdentityInfoManager().updateUserLock(user, attempts, lockExpirationTime);
    }

    @Override
    public IdentityOperationResult unlockUser(String userId) {
        UserEntity user = this.findUserById(userId);
        if (user != null) {
            return this.unlockUser(user);
        }
        return new IdentityOperationResult(null, "none");
    }

    protected IdentityOperationResult unlockUser(UserEntity user) {
        if (user.getAttempts() > 0 || user.getLockExpirationTime() != null) {
            this.getIdentityInfoManager().updateUserLock(user, 0, null);
            return new IdentityOperationResult(user, "unlock");
        }
        return new IdentityOperationResult(user, "none");
    }

    @Override
    public GroupEntity createNewGroup(String groupId) {
        return new GroupEntity(groupId);
    }

    @Override
    public IdentityOperationResult saveGroup(Group group) {
        GroupEntity groupEntity = (GroupEntity)group;
        String operation = null;
        if (groupEntity.getRevision() == 0) {
            operation = "create";
            this.checkAuthorization(Permissions.CREATE, Resources.GROUP, null);
            this.getDbEntityManager().insert(groupEntity);
            this.createDefaultAuthorizations(group);
        } else {
            operation = "update";
            this.checkAuthorization(Permissions.UPDATE, Resources.GROUP, group.getId());
            this.getDbEntityManager().merge(groupEntity);
        }
        return new IdentityOperationResult(groupEntity, operation);
    }

    @Override
    public IdentityOperationResult deleteGroup(final String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP, groupId);
        GroupEntity group = this.findGroupById(groupId);
        if (group != null) {
            this.deleteMembershipsByGroupId(groupId);
            this.deleteTenantMembershipsOfGroup(groupId);
            this.deleteAuthorizations(Resources.GROUP, groupId);
            Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    List tenants = DbIdentityServiceProvider.this.createTenantQuery().groupMember(groupId).list();
                    if (tenants != null && !tenants.isEmpty()) {
                        for (Tenant tenant : tenants) {
                            DbIdentityServiceProvider.this.deleteAuthorizationsForGroup(Resources.TENANT, tenant.getId(), groupId);
                        }
                    }
                    return null;
                }
            });
            this.getDbEntityManager().delete(group);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    @Override
    public Tenant createNewTenant(String tenantId) {
        return new TenantEntity(tenantId);
    }

    @Override
    public IdentityOperationResult saveTenant(Tenant tenant) {
        TenantEntity tenantEntity = (TenantEntity)tenant;
        String operation = null;
        if (tenantEntity.getRevision() == 0) {
            operation = "create";
            this.checkAuthorization(Permissions.CREATE, Resources.TENANT, null);
            this.getDbEntityManager().insert(tenantEntity);
            this.createDefaultAuthorizations(tenant);
        } else {
            operation = "update";
            this.checkAuthorization(Permissions.UPDATE, Resources.TENANT, tenant.getId());
            this.getDbEntityManager().merge(tenantEntity);
        }
        return new IdentityOperationResult(tenantEntity, operation);
    }

    @Override
    public IdentityOperationResult deleteTenant(String tenantId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        if (tenant != null) {
            this.deleteTenantMembershipsOfTenant(tenantId);
            this.deleteAuthorizations(Resources.TENANT, tenantId);
            this.getDbEntityManager().delete(tenant);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    @Override
    public IdentityOperationResult createMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.GROUP_MEMBERSHIP, groupId);
        UserEntity user = this.findUserById(userId);
        EnsureUtil.ensureNotNull("No user found with id '" + userId + "'.", "user", (Object)user);
        GroupEntity group = this.findGroupById(groupId);
        EnsureUtil.ensureNotNull("No group found with id '" + groupId + "'.", "group", (Object)group);
        MembershipEntity membership = new MembershipEntity();
        membership.setUser(user);
        membership.setGroup(group);
        this.getDbEntityManager().insert(membership);
        this.createDefaultMembershipAuthorizations(userId, groupId);
        return new IdentityOperationResult(null, "create");
    }

    @Override
    public IdentityOperationResult deleteMembership(String userId, String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.GROUP_MEMBERSHIP, groupId);
        if (this.existsMembership(userId, groupId)) {
            this.deleteAuthorizationsForUser(Resources.GROUP_MEMBERSHIP, groupId, userId);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("userId", userId);
            parameters.put("groupId", groupId);
            this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembership", parameters);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    protected void deleteMembershipsByUserId(String userId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByUserId", userId);
    }

    protected void deleteMembershipsByGroupId(String groupId) {
        this.getDbEntityManager().delete(MembershipEntity.class, "deleteMembershipsByGroupId", groupId);
    }

    @Override
    public IdentityOperationResult createTenantUserMembership(String tenantId, String userId) {
        this.checkAuthorization(Permissions.CREATE, Resources.TENANT_MEMBERSHIP, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        UserEntity user = this.findUserById(userId);
        EnsureUtil.ensureNotNull("No tenant found with id '" + tenantId + "'.", "tenant", (Object)tenant);
        EnsureUtil.ensureNotNull("No user found with id '" + userId + "'.", "user", (Object)user);
        TenantMembershipEntity membership = new TenantMembershipEntity();
        membership.setTenant(tenant);
        membership.setUser(user);
        this.getDbEntityManager().insert(membership);
        this.createDefaultTenantMembershipAuthorizations((Tenant)tenant, user);
        return new IdentityOperationResult(null, "create");
    }

    @Override
    public IdentityOperationResult createTenantGroupMembership(String tenantId, String groupId) {
        this.checkAuthorization(Permissions.CREATE, Resources.TENANT_MEMBERSHIP, tenantId);
        TenantEntity tenant = this.findTenantById(tenantId);
        GroupEntity group = this.findGroupById(groupId);
        EnsureUtil.ensureNotNull("No tenant found with id '" + tenantId + "'.", "tenant", (Object)tenant);
        EnsureUtil.ensureNotNull("No group found with id '" + groupId + "'.", "group", (Object)group);
        TenantMembershipEntity membership = new TenantMembershipEntity();
        membership.setTenant(tenant);
        membership.setGroup(group);
        this.getDbEntityManager().insert(membership);
        this.createDefaultTenantMembershipAuthorizations((Tenant)tenant, group);
        return new IdentityOperationResult(null, "create");
    }

    @Override
    public IdentityOperationResult deleteTenantUserMembership(String tenantId, String userId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT_MEMBERSHIP, tenantId);
        if (this.existsTenantMembership(tenantId, userId, null)) {
            this.deleteAuthorizations(Resources.TENANT_MEMBERSHIP, userId);
            this.deleteAuthorizationsForUser(Resources.TENANT, tenantId, userId);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("tenantId", tenantId);
            parameters.put("userId", userId);
            this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembership", parameters);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    @Override
    public IdentityOperationResult deleteTenantGroupMembership(String tenantId, String groupId) {
        this.checkAuthorization(Permissions.DELETE, Resources.TENANT_MEMBERSHIP, tenantId);
        if (this.existsTenantMembership(tenantId, null, groupId)) {
            this.deleteAuthorizations(Resources.TENANT_MEMBERSHIP, groupId);
            this.deleteAuthorizationsForGroup(Resources.TENANT, tenantId, groupId);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("tenantId", tenantId);
            parameters.put("groupId", groupId);
            this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembership", parameters);
            return new IdentityOperationResult(null, "delete");
        }
        return new IdentityOperationResult(null, "none");
    }

    protected void deleteTenantMembershipsOfUser(String userId) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfUser", userId);
    }

    protected void deleteTenantMembershipsOfGroup(String groupId) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfGroup", groupId);
    }

    protected void deleteTenantMembershipsOfTenant(String tenant) {
        this.getDbEntityManager().delete(TenantMembershipEntity.class, "deleteTenantMembershipsOfTenant", tenant);
    }

    protected void createDefaultAuthorizations(UserEntity userEntity) {
        if (Context.getProcessEngineConfiguration().isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newUser(userEntity));
        }
    }

    protected void createDefaultAuthorizations(Group group) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newGroup(group));
        }
    }

    protected void createDefaultAuthorizations(Tenant tenant) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().newTenant(tenant));
        }
    }

    protected void createDefaultMembershipAuthorizations(String userId, String groupId) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().groupMembershipCreated(groupId, userId));
        }
    }

    protected void createDefaultTenantMembershipAuthorizations(Tenant tenant, User user) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().tenantMembershipCreated(tenant, user));
        }
    }

    protected void createDefaultTenantMembershipAuthorizations(Tenant tenant, Group group) {
        if (this.isAuthorizationEnabled()) {
            this.saveDefaultAuthorizations(this.getResourceAuthorizationProvider().tenantMembershipCreated(tenant, group));
        }
    }
}

