/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.json.JsonArrayConverter;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.json.JSONArray;
import org.camunda.bpm.engine.impl.util.json.JSONObject;

public class JsonArrayOfObjectsConverter<T>
extends JsonArrayConverter<List<T>> {
    protected JsonObjectConverter<T> objectConverter;

    public JsonArrayOfObjectsConverter(JsonObjectConverter<T> objectConverter) {
        this.objectConverter = objectConverter;
    }

    @Override
    public JSONArray toJsonArray(List<T> objects) {
        JSONArray jsonArray = new JSONArray();
        for (T object : objects) {
            JSONObject jsonObject = this.objectConverter.toJsonObject(object);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    @Override
    public List<T> toObject(JSONArray jsonArray) {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            T object = this.objectConverter.toObject(jsonArray.getJSONObject(i));
            result.add(object);
        }
        return result;
    }
}

