/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.dmn.engine.DmnEngine;
import org.camunda.bpm.dmn.engine.DmnEngineConfiguration;
import org.camunda.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngine;
import org.camunda.bpm.dmn.engine.impl.el.DefaultScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.el.JuelElProvider;
import org.camunda.bpm.dmn.engine.impl.metrics.DefaultEngineMetricCollector;
import org.camunda.bpm.dmn.engine.impl.spi.el.DmnScriptEngineResolver;
import org.camunda.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.dmn.engine.impl.transform.DefaultDmnTransformer;
import org.camunda.bpm.dmn.engine.spi.DmnEngineMetricCollector;
import org.camunda.bpm.dmn.feel.impl.FeelEngine;
import org.camunda.bpm.dmn.feel.impl.FeelEngineFactory;
import org.camunda.bpm.dmn.feel.impl.juel.FeelEngineFactoryImpl;

public class DefaultDmnEngineConfiguration
extends DmnEngineConfiguration {
    public static final String FEEL_EXPRESSION_LANGUAGE = "http://www.omg.org/spec/FEEL/20140401";
    public static final String FEEL_EXPRESSION_LANGUAGE_ALTERNATIVE = "feel";
    public static final String JUEL_EXPRESSION_LANGUAGE = "juel";
    protected DmnEngineMetricCollector engineMetricCollector;
    protected List<DmnDecisionTableEvaluationListener> customPreDecisionTableEvaluationListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
    protected List<DmnDecisionTableEvaluationListener> customPostDecisionTableEvaluationListeners = new ArrayList<DmnDecisionTableEvaluationListener>();
    protected List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners;
    protected DmnScriptEngineResolver scriptEngineResolver;
    protected ElProvider elProvider;
    protected FeelEngineFactory feelEngineFactory;
    protected FeelEngine feelEngine;
    protected String defaultInputExpressionExpressionLanguage = "juel";
    protected String defaultInputEntryExpressionLanguage = "http://www.omg.org/spec/FEEL/20140401";
    protected String defaultOutputEntryExpressionLanguage = "juel";
    protected DmnTransformer transformer = new DefaultDmnTransformer();

    @Override
    public DmnEngine buildEngine() {
        this.init();
        return new DefaultDmnEngine(this);
    }

    public void init() {
        this.initMetricCollector();
        this.initDecisionTableEvaluationListener();
        this.initScriptEngineResolver();
        this.initElProvider();
        this.initFeelEngine();
    }

    protected void initMetricCollector() {
        if (this.engineMetricCollector == null) {
            this.engineMetricCollector = new DefaultEngineMetricCollector();
        }
    }

    protected void initDecisionTableEvaluationListener() {
        ArrayList<DmnDecisionTableEvaluationListener> listeners = new ArrayList<DmnDecisionTableEvaluationListener>();
        if (this.customPreDecisionTableEvaluationListeners != null && !this.customPreDecisionTableEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPreDecisionTableEvaluationListeners);
        }
        listeners.addAll(this.getDefaultDmnDecisionTableEvaluationListeners());
        if (this.customPostDecisionTableEvaluationListeners != null && !this.customPostDecisionTableEvaluationListeners.isEmpty()) {
            listeners.addAll(this.customPostDecisionTableEvaluationListeners);
        }
        this.decisionTableEvaluationListeners = listeners;
    }

    protected Collection<? extends DmnDecisionTableEvaluationListener> getDefaultDmnDecisionTableEvaluationListeners() {
        ArrayList<DmnEngineMetricCollector> defaultListeners = new ArrayList<DmnEngineMetricCollector>();
        defaultListeners.add(this.engineMetricCollector);
        return defaultListeners;
    }

    protected void initElProvider() {
        if (this.elProvider == null) {
            this.elProvider = new JuelElProvider();
        }
    }

    protected void initScriptEngineResolver() {
        if (this.scriptEngineResolver == null) {
            this.scriptEngineResolver = new DefaultScriptEngineResolver();
        }
    }

    protected void initFeelEngine() {
        if (this.feelEngineFactory == null) {
            this.feelEngineFactory = new FeelEngineFactoryImpl();
        }
        if (this.feelEngine == null) {
            this.feelEngine = this.feelEngineFactory.createInstance();
        }
    }

    @Override
    public DmnEngineMetricCollector getEngineMetricCollector() {
        return this.engineMetricCollector;
    }

    @Override
    public void setEngineMetricCollector(DmnEngineMetricCollector engineMetricCollector) {
        this.engineMetricCollector = engineMetricCollector;
    }

    @Override
    public DefaultDmnEngineConfiguration engineMetricCollector(DmnEngineMetricCollector engineMetricCollector) {
        this.setEngineMetricCollector(engineMetricCollector);
        return this;
    }

    @Override
    public List<DmnDecisionTableEvaluationListener> getCustomPreDecisionTableEvaluationListeners() {
        return this.customPreDecisionTableEvaluationListeners;
    }

    @Override
    public void setCustomPreDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.customPreDecisionTableEvaluationListeners = decisionTableEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPreDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.setCustomPreDecisionTableEvaluationListeners(decisionTableEvaluationListeners);
        return this;
    }

    @Override
    public List<DmnDecisionTableEvaluationListener> getCustomPostDecisionTableEvaluationListeners() {
        return this.customPostDecisionTableEvaluationListeners;
    }

    @Override
    public void setCustomPostDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.customPostDecisionTableEvaluationListeners = decisionTableEvaluationListeners;
    }

    @Override
    public DefaultDmnEngineConfiguration customPostDecisionTableEvaluationListeners(List<DmnDecisionTableEvaluationListener> decisionTableEvaluationListeners) {
        this.setCustomPostDecisionTableEvaluationListeners(decisionTableEvaluationListeners);
        return this;
    }

    public List<DmnDecisionTableEvaluationListener> getDecisionTableEvaluationListeners() {
        return this.decisionTableEvaluationListeners;
    }

    public DmnScriptEngineResolver getScriptEngineResolver() {
        return this.scriptEngineResolver;
    }

    public void setScriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.scriptEngineResolver = scriptEngineResolver;
    }

    public DefaultDmnEngineConfiguration scriptEngineResolver(DmnScriptEngineResolver scriptEngineResolver) {
        this.setScriptEngineResolver(scriptEngineResolver);
        return this;
    }

    public ElProvider getElProvider() {
        return this.elProvider;
    }

    public void setElProvider(ElProvider elProvider) {
        this.elProvider = elProvider;
    }

    public DefaultDmnEngineConfiguration elProvider(ElProvider elProvider) {
        this.setElProvider(elProvider);
        return this;
    }

    public FeelEngineFactory getFeelEngineFactory() {
        return this.feelEngineFactory;
    }

    public void setFeelEngineFactory(FeelEngineFactory feelEngineFactory) {
        this.feelEngineFactory = feelEngineFactory;
        this.feelEngine = null;
    }

    public DefaultDmnEngineConfiguration feelEngineFactory(FeelEngineFactory feelEngineFactory) {
        this.setFeelEngineFactory(feelEngineFactory);
        return this;
    }

    public FeelEngine getFeelEngine() {
        return this.feelEngine;
    }

    public String getDefaultInputExpressionExpressionLanguage() {
        return this.defaultInputExpressionExpressionLanguage;
    }

    public void setDefaultInputExpressionExpressionLanguage(String expressionLanguage) {
        this.defaultInputExpressionExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultInputExpressionExpressionLanguage(String expressionLanguage) {
        this.setDefaultInputExpressionExpressionLanguage(expressionLanguage);
        return this;
    }

    public String getDefaultInputEntryExpressionLanguage() {
        return this.defaultInputEntryExpressionLanguage;
    }

    public void setDefaultInputEntryExpressionLanguage(String expressionLanguage) {
        this.defaultInputEntryExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultInputEntryExpressionLanguage(String expressionLanguage) {
        this.setDefaultInputEntryExpressionLanguage(expressionLanguage);
        return this;
    }

    public String getDefaultOutputEntryExpressionLanguage() {
        return this.defaultOutputEntryExpressionLanguage;
    }

    public void setDefaultOutputEntryExpressionLanguage(String expressionLanguage) {
        this.defaultOutputEntryExpressionLanguage = expressionLanguage;
    }

    public DefaultDmnEngineConfiguration defaultOutputEntryExpressionLanguage(String expressionLanguage) {
        this.setDefaultOutputEntryExpressionLanguage(expressionLanguage);
        return this;
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }

    public DefaultDmnEngineConfiguration transformer(DmnTransformer transformer) {
        this.setTransformer(transformer);
        return this;
    }
}

