/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.cmmn.impl;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.SchemaFactory;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelException;
import org.camunda.bpm.model.cmmn.impl.CmmnModelInstanceImpl;
import org.camunda.bpm.model.xml.ModelParseException;
import org.camunda.bpm.model.xml.ModelValidationException;
import org.camunda.bpm.model.xml.impl.ModelImpl;
import org.camunda.bpm.model.xml.impl.parser.AbstractModelParser;
import org.camunda.bpm.model.xml.impl.util.ReflectUtil;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.xml.sax.SAXException;

public class CmmnParser
extends AbstractModelParser {
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public CmmnParser() {
        this.schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        URL cmmnSchema = ReflectUtil.getResource((String)"CMMN10.xsd", (ClassLoader)CmmnParser.class.getClassLoader());
        try {
            this.schema = this.schemaFactory.newSchema(cmmnSchema);
        }
        catch (SAXException e) {
            throw new ModelValidationException("Unable to parse schema:" + cmmnSchema);
        }
    }

    protected void configureFactory(DocumentBuilderFactory dbf) {
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        dbf.setAttribute(JAXP_SCHEMA_SOURCE, ReflectUtil.getResource((String)"CMMN10.xsd", (ClassLoader)CmmnParser.class.getClassLoader()).toString());
        super.configureFactory(dbf);
    }

    protected CmmnModelInstanceImpl createModelInstance(DomDocument document) {
        return new CmmnModelInstanceImpl((ModelImpl)Cmmn.INSTANCE.getCmmnModel(), Cmmn.INSTANCE.getCmmnModelBuilder(), document);
    }

    public CmmnModelInstanceImpl parseModelFromStream(InputStream inputStream) {
        try {
            return (CmmnModelInstanceImpl)super.parseModelFromStream(inputStream);
        }
        catch (ModelParseException e) {
            throw new CmmnModelException("Unable to parse model", e);
        }
    }

    public CmmnModelInstanceImpl getEmptyModel() {
        return (CmmnModelInstanceImpl)super.getEmptyModel();
    }
}

