/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.filter;

import java.util.Arrays;
import javax.servlet.FilterConfig;
import org.camunda.bpm.engine.ProcessEngineException;

public class CsrfPreventionCookieConfigurator {
    protected static final String ENABLE_SECURE_PARAM = "enableSecureCookie";
    protected static final String ENABLE_SAME_SITE_PARAM = "enableSameSiteCookie";
    protected static final String SAME_SITE_OPTION_PARAM = "sameSiteCookieOption";
    protected static final String SAME_SITE_VALUE_PARAM = "sameSiteCookieValue";
    protected boolean isSecureCookieEnabled;
    protected boolean isSameSiteCookieEnabled;
    protected String sameSiteCookieValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseParams(FilterConfig filterConfig) {
        String enableSameSiteCookie;
        String enableSecureCookie = filterConfig.getInitParameter(ENABLE_SECURE_PARAM);
        if (!this.isEmpty(enableSecureCookie)) {
            this.isSecureCookieEnabled = Boolean.valueOf(enableSecureCookie);
        }
        this.isSameSiteCookieEnabled = !this.isEmpty(enableSameSiteCookie = filterConfig.getInitParameter(ENABLE_SAME_SITE_PARAM)) ? Boolean.valueOf(enableSameSiteCookie) : true;
        String sameSiteCookieValue = filterConfig.getInitParameter(SAME_SITE_VALUE_PARAM);
        String sameSiteCookieOption = filterConfig.getInitParameter(SAME_SITE_OPTION_PARAM);
        if (!this.isEmpty(sameSiteCookieValue) && !this.isEmpty(sameSiteCookieOption)) {
            throw new ProcessEngineException("Please either configure sameSiteCookieOption or sameSiteCookieValue.");
        }
        if (!this.isEmpty(sameSiteCookieValue)) {
            this.sameSiteCookieValue = sameSiteCookieValue;
            return;
        } else if (!this.isEmpty(sameSiteCookieOption)) {
            if (SameSiteOption.LAX.compareTo(sameSiteCookieOption)) {
                this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
                return;
            } else {
                if (!SameSiteOption.STRICT.compareTo(sameSiteCookieOption)) throw new ProcessEngineException("For sameSiteCookieOption param, please configure one of the following options: " + Arrays.toString((Object[])SameSiteOption.values()));
                this.sameSiteCookieValue = SameSiteOption.STRICT.getValue();
            }
            return;
        } else {
            this.sameSiteCookieValue = SameSiteOption.LAX.getValue();
        }
    }

    public String getConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isSameSiteCookieEnabled) {
            stringBuilder.append(";SameSite=").append(this.sameSiteCookieValue);
        }
        if (this.isSecureCookieEnabled) {
            stringBuilder.append(";Secure");
        }
        return stringBuilder.toString();
    }

    protected boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static enum SameSiteOption {
        LAX("Lax"),
        STRICT("Strict");

        protected final String value;

        private SameSiteOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.name();
        }

        public boolean compareTo(String value) {
            return this.value.equalsIgnoreCase(value);
        }
    }
}

