/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.protocol;

import connectjar.org.apache.http.HttpEntityEnclosingRequest;
import connectjar.org.apache.http.HttpException;
import connectjar.org.apache.http.HttpRequest;
import connectjar.org.apache.http.HttpRequestInterceptor;
import connectjar.org.apache.http.annotation.Contract;
import connectjar.org.apache.http.annotation.ThreadingBehavior;
import connectjar.org.apache.http.protocol.HttpContext;
import connectjar.org.apache.http.protocol.HttpDateGenerator;
import connectjar.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

