/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;

public class ColumnFamilyStoreCQLHelper {
    public static List<String> dumpReCreateStatements(CFMetaData metadata) {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(ColumnFamilyStoreCQLHelper.getUserTypesAsCQL(metadata));
        l.add(ColumnFamilyStoreCQLHelper.getCFMetadataAsCQL(metadata, true));
        l.addAll(ColumnFamilyStoreCQLHelper.getDroppedColumnsAsCQL(metadata));
        l.addAll(ColumnFamilyStoreCQLHelper.getIndexesAsCQL(metadata));
        return l;
    }

    private static List<ColumnDefinition> getClusteringColumns(CFMetaData metadata) {
        ArrayList<ColumnDefinition> cds = new ArrayList<ColumnDefinition>(metadata.clusteringColumns().size());
        if (!metadata.isStaticCompactTable()) {
            for (ColumnDefinition cd : metadata.clusteringColumns()) {
                cds.add(cd);
            }
        }
        return cds;
    }

    private static List<ColumnDefinition> getPartitionColumns(CFMetaData metadata) {
        ArrayList<ColumnDefinition> cds;
        block4: {
            block3: {
                cds = new ArrayList<ColumnDefinition>(metadata.partitionColumns().size());
                for (ColumnDefinition cd : metadata.partitionColumns().statics) {
                    cds.add(cd);
                }
                if (!metadata.isDense()) break block3;
                for (ColumnDefinition cd : metadata.partitionColumns().withoutStatics()) {
                    if (cd.type.equals(EmptyType.instance)) continue;
                    cds.add(cd);
                }
                break block4;
            }
            if (metadata.isStaticCompactTable()) break block4;
            for (ColumnDefinition cd : metadata.partitionColumns().withoutStatics()) {
                cds.add(cd);
            }
        }
        return cds;
    }

    @VisibleForTesting
    public static String getCFMetadataAsCQL(CFMetaData metadata, boolean includeDroppedColumns) {
        StringBuilder sb = new StringBuilder();
        if (!ColumnFamilyStoreCQLHelper.isCqlCompatible(metadata)) {
            sb.append(String.format("/*\nWarning: Table %s.%s omitted because it has constructs not compatible with CQL (was created via legacy API).\n", metadata.ksName, metadata.cfName));
            sb.append("\nApproximate structure, for reference:");
            sb.append("\n(this should not be used to reproduce this schema)\n\n");
        }
        sb.append("CREATE TABLE IF NOT EXISTS ");
        sb.append(ColumnFamilyStoreCQLHelper.quoteIdentifier(metadata.ksName)).append('.').append(ColumnFamilyStoreCQLHelper.quoteIdentifier(metadata.cfName)).append(" (");
        List<ColumnDefinition> partitionKeyColumns = metadata.partitionKeyColumns();
        List<ColumnDefinition> clusteringColumns = ColumnFamilyStoreCQLHelper.getClusteringColumns(metadata);
        List<ColumnDefinition> partitionColumns = ColumnFamilyStoreCQLHelper.getPartitionColumns(metadata);
        Consumer<StringBuilder> cdCommaAppender = ColumnFamilyStoreCQLHelper.commaAppender("\n\t");
        sb.append("\n\t");
        for (ColumnDefinition columnDefinition : partitionKeyColumns) {
            cdCommaAppender.accept(sb);
            sb.append(ColumnFamilyStoreCQLHelper.toCQL(columnDefinition));
            if (partitionKeyColumns.size() != 1 || clusteringColumns.size() != 0) continue;
            sb.append(" PRIMARY KEY");
        }
        for (ColumnDefinition columnDefinition : clusteringColumns) {
            cdCommaAppender.accept(sb);
            sb.append(ColumnFamilyStoreCQLHelper.toCQL(columnDefinition));
        }
        for (ColumnDefinition columnDefinition : partitionColumns) {
            cdCommaAppender.accept(sb);
            sb.append(ColumnFamilyStoreCQLHelper.toCQL(columnDefinition, metadata.isStaticCompactTable()));
        }
        if (includeDroppedColumns) {
            for (Map.Entry entry : metadata.getDroppedColumns().entrySet()) {
                if (metadata.getColumnDefinition((ByteBuffer)entry.getKey()) != null) continue;
                CFMetaData.DroppedColumn droppedColumn = (CFMetaData.DroppedColumn)entry.getValue();
                cdCommaAppender.accept(sb);
                sb.append(ColumnFamilyStoreCQLHelper.quoteIdentifier(droppedColumn.name));
                sb.append(' ');
                sb.append(droppedColumn.type.asCQL3Type().toString());
            }
        }
        if (clusteringColumns.size() > 0 || partitionKeyColumns.size() > 1) {
            sb.append(",\n\tPRIMARY KEY (");
            if (partitionKeyColumns.size() > 1) {
                sb.append("(");
                Consumer<StringBuilder> pkCommaAppender = ColumnFamilyStoreCQLHelper.commaAppender(" ");
                for (ColumnDefinition cfd : partitionKeyColumns) {
                    pkCommaAppender.accept(sb);
                    sb.append(ColumnFamilyStoreCQLHelper.quoteIdentifier(cfd.name.toString()));
                }
                sb.append(")");
            } else {
                sb.append(ColumnFamilyStoreCQLHelper.quoteIdentifier(partitionKeyColumns.get((int)0).name.toString()));
            }
            for (ColumnDefinition columnDefinition : metadata.clusteringColumns()) {
                sb.append(", ").append(ColumnFamilyStoreCQLHelper.quoteIdentifier(columnDefinition.name.toString()));
            }
            sb.append(')');
        }
        sb.append(")\n\t");
        sb.append("WITH ");
        sb.append("ID = ").append(metadata.cfId).append("\n\tAND ");
        if (metadata.isCompactTable()) {
            sb.append("COMPACT STORAGE\n\tAND ");
        }
        if (clusteringColumns.size() > 0) {
            sb.append("CLUSTERING ORDER BY (");
            Consumer<StringBuilder> cOrderCommaAppender = ColumnFamilyStoreCQLHelper.commaAppender(" ");
            for (ColumnDefinition cd : clusteringColumns) {
                cOrderCommaAppender.accept(sb);
                sb.append(ColumnFamilyStoreCQLHelper.quoteIdentifier(cd.name.toString())).append(' ').append(cd.clusteringOrder().toString());
            }
            sb.append(")\n\tAND ");
        }
        sb.append(ColumnFamilyStoreCQLHelper.toCQL(metadata.params));
        sb.append(";");
        if (!ColumnFamilyStoreCQLHelper.isCqlCompatible(metadata)) {
            sb.append("\n*/");
        }
        return sb.toString();
    }

    @VisibleForTesting
    public static List<String> getUserTypesAsCQL(CFMetaData metadata) {
        ArrayList<AbstractType> types = new ArrayList<AbstractType>();
        HashSet<AbstractType> typeSet = new HashSet<AbstractType>();
        for (ColumnDefinition cd : Iterables.concat(metadata.partitionKeyColumns(), metadata.clusteringColumns(), metadata.partitionColumns())) {
            AbstractType type = cd.type;
            if (!type.isUDT()) continue;
            ColumnFamilyStoreCQLHelper.resolveUserType((UserType)type, typeSet, types);
        }
        ArrayList<String> typeStrings = new ArrayList<String>();
        for (AbstractType type : types) {
            typeStrings.add(ColumnFamilyStoreCQLHelper.toCQL((UserType)type));
        }
        return typeStrings;
    }

    @VisibleForTesting
    public static List<String> getDroppedColumnsAsCQL(CFMetaData metadata) {
        ArrayList<String> droppedColumns = new ArrayList<String>();
        for (Map.Entry<ByteBuffer, CFMetaData.DroppedColumn> entry : metadata.getDroppedColumns().entrySet()) {
            CFMetaData.DroppedColumn column = entry.getValue();
            droppedColumns.add(ColumnFamilyStoreCQLHelper.toCQLDrop(metadata.ksName, metadata.cfName, column));
            if (metadata.getColumnDefinition(entry.getKey()) == null) continue;
            droppedColumns.add(ColumnFamilyStoreCQLHelper.toCQLAdd(metadata.ksName, metadata.cfName, metadata.getColumnDefinition(entry.getKey())));
        }
        return droppedColumns;
    }

    @VisibleForTesting
    public static List<String> getIndexesAsCQL(CFMetaData metadata) {
        ArrayList<String> indexes = new ArrayList<String>();
        for (IndexMetadata indexMetadata : metadata.getIndexes()) {
            indexes.add(ColumnFamilyStoreCQLHelper.toCQL(metadata.ksName, metadata.cfName, indexMetadata));
        }
        return indexes;
    }

    private static String toCQL(String keyspace, String cf, IndexMetadata indexMetadata) {
        if (indexMetadata.isCustom()) {
            HashMap options = new HashMap();
            indexMetadata.options.forEach((k, v) -> {
                if (!k.equals("target") && !k.equals("class_name")) {
                    options.put(k, v);
                }
            });
            return String.format("CREATE CUSTOM INDEX %s ON %s.%s (%s) USING '%s'%s;", ColumnFamilyStoreCQLHelper.quoteIdentifier(indexMetadata.name), ColumnFamilyStoreCQLHelper.quoteIdentifier(keyspace), ColumnFamilyStoreCQLHelper.quoteIdentifier(cf), indexMetadata.options.get("target"), indexMetadata.options.get("class_name"), options.isEmpty() ? "" : " WITH OPTIONS " + ColumnFamilyStoreCQLHelper.toCQL(options));
        }
        return String.format("CREATE INDEX %s ON %s.%s (%s);", ColumnFamilyStoreCQLHelper.quoteIdentifier(indexMetadata.name), ColumnFamilyStoreCQLHelper.quoteIdentifier(keyspace), ColumnFamilyStoreCQLHelper.quoteIdentifier(cf), indexMetadata.options.get("target"));
    }

    private static String toCQL(UserType userType) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CREATE TYPE %s.%s(", ColumnFamilyStoreCQLHelper.quoteIdentifier(userType.keyspace), ColumnFamilyStoreCQLHelper.quoteIdentifier(userType.getNameAsString())));
        Consumer<StringBuilder> commaAppender = ColumnFamilyStoreCQLHelper.commaAppender(" ");
        for (int i = 0; i < userType.size(); ++i) {
            commaAppender.accept(sb);
            sb.append(String.format("%s %s", userType.fieldNameAsString(i), userType.fieldType(i).asCQL3Type()));
        }
        sb.append(");");
        return sb.toString();
    }

    private static String toCQL(TableParams tableParams) {
        StringBuilder builder = new StringBuilder();
        builder.append("bloom_filter_fp_chance = ").append(tableParams.bloomFilterFpChance);
        builder.append("\n\tAND dclocal_read_repair_chance = ").append(tableParams.dcLocalReadRepairChance);
        builder.append("\n\tAND crc_check_chance = ").append(tableParams.crcCheckChance);
        builder.append("\n\tAND default_time_to_live = ").append(tableParams.defaultTimeToLive);
        builder.append("\n\tAND gc_grace_seconds = ").append(tableParams.gcGraceSeconds);
        builder.append("\n\tAND min_index_interval = ").append(tableParams.minIndexInterval);
        builder.append("\n\tAND max_index_interval = ").append(tableParams.maxIndexInterval);
        builder.append("\n\tAND memtable_flush_period_in_ms = ").append(tableParams.memtableFlushPeriodInMs);
        builder.append("\n\tAND read_repair_chance = ").append(tableParams.readRepairChance);
        builder.append("\n\tAND speculative_retry = '").append(tableParams.speculativeRetry).append("'");
        builder.append("\n\tAND comment = ").append(ColumnFamilyStoreCQLHelper.singleQuote(tableParams.comment));
        builder.append("\n\tAND caching = ").append(ColumnFamilyStoreCQLHelper.toCQL(tableParams.caching.asMap()));
        builder.append("\n\tAND compaction = ").append(ColumnFamilyStoreCQLHelper.toCQL(tableParams.compaction.asMap()));
        builder.append("\n\tAND compression = ").append(ColumnFamilyStoreCQLHelper.toCQL(tableParams.compression.asMap()));
        builder.append("\n\tAND cdc = ").append(tableParams.cdc);
        builder.append("\n\tAND extensions = { ");
        for (Map.Entry entry : tableParams.extensions.entrySet()) {
            builder.append(ColumnFamilyStoreCQLHelper.singleQuote((String)entry.getKey()));
            builder.append(": ");
            builder.append("0x").append(ByteBufferUtil.bytesToHex((ByteBuffer)entry.getValue()));
        }
        builder.append(" }");
        return builder.toString();
    }

    private static String toCQL(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder("{ ");
        boolean isFirst = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append(", ");
            }
            builder.append(ColumnFamilyStoreCQLHelper.singleQuote(entry.getKey().toString()));
            builder.append(": ");
            builder.append(ColumnFamilyStoreCQLHelper.singleQuote(entry.getValue().toString()));
        }
        builder.append(" }");
        return builder.toString();
    }

    private static String toCQL(ColumnDefinition cd) {
        return ColumnFamilyStoreCQLHelper.toCQL(cd, false);
    }

    private static String toCQL(ColumnDefinition cd, boolean isStaticCompactTable) {
        return String.format("%s %s%s", ColumnFamilyStoreCQLHelper.quoteIdentifier(cd.name.toString()), cd.type.asCQL3Type().toString(), cd.isStatic() && !isStaticCompactTable ? " static" : "");
    }

    private static String toCQLAdd(String keyspace, String cf, ColumnDefinition cd) {
        return String.format("ALTER TABLE %s.%s ADD %s %s%s;", ColumnFamilyStoreCQLHelper.quoteIdentifier(keyspace), ColumnFamilyStoreCQLHelper.quoteIdentifier(cf), ColumnFamilyStoreCQLHelper.quoteIdentifier(cd.name.toString()), cd.type.asCQL3Type().toString(), cd.isStatic() ? " static" : "");
    }

    private static String toCQLDrop(String keyspace, String cf, CFMetaData.DroppedColumn droppedColumn) {
        return String.format("ALTER TABLE %s.%s DROP %s USING TIMESTAMP %s;", ColumnFamilyStoreCQLHelper.quoteIdentifier(keyspace), ColumnFamilyStoreCQLHelper.quoteIdentifier(cf), ColumnFamilyStoreCQLHelper.quoteIdentifier(droppedColumn.name), droppedColumn.droppedTime);
    }

    private static void resolveUserType(UserType type, Set<AbstractType> typeSet, List<AbstractType> types) {
        for (AbstractType<?> subType : type.fieldTypes()) {
            if (typeSet.contains(subType) || !subType.isUDT()) continue;
            ColumnFamilyStoreCQLHelper.resolveUserType((UserType)subType, typeSet, types);
        }
        if (!typeSet.contains(type)) {
            typeSet.add(type);
            types.add(type);
        }
    }

    private static String singleQuote(String s) {
        return String.format("'%s'", s.replaceAll("'", "''"));
    }

    private static Consumer<StringBuilder> commaAppender(final String afterComma) {
        final AtomicBoolean isFirst = new AtomicBoolean(true);
        return new Consumer<StringBuilder>(){

            @Override
            public void accept(StringBuilder stringBuilder) {
                if (!isFirst.getAndSet(false)) {
                    stringBuilder.append(',').append(afterComma);
                }
            }
        };
    }

    private static String quoteIdentifier(String id) {
        return ColumnIdentifier.maybeQuote(id);
    }

    public static boolean isCqlCompatible(CFMetaData metaData) {
        if (metaData.isSuper()) {
            return false;
        }
        return !metaData.isCompactTable() || metaData.partitionColumns().withoutStatics().size() <= 1 || metaData.clusteringColumns().size() < 1;
    }
}

