/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterator;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionStrategyManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.DefaultCompactionWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.Refs;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.shaded.com.google.common.base.Predicate;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Sets;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTask
extends AbstractCompactionTask {
    protected static final Logger logger = LoggerFactory.getLogger(CompactionTask.class);
    protected final int gcBefore;
    protected final boolean keepOriginals;
    protected static long totalBytesCompacted = 0L;
    private CompactionManager.CompactionExecutorStatsCollector collector;

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore) {
        this(cfs, txn, gcBefore, false);
    }

    @Deprecated
    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore, boolean offline, boolean keepOriginals) {
        this(cfs, txn, gcBefore, keepOriginals);
    }

    public CompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int gcBefore, boolean keepOriginals) {
        super(cfs, txn);
        this.gcBefore = gcBefore;
        this.keepOriginals = keepOriginals;
    }

    public static synchronized long addToTotalBytesCompacted(long bytesCompacted) {
        return totalBytesCompacted += bytesCompacted;
    }

    @Override
    protected int executeInternal(CompactionManager.CompactionExecutorStatsCollector collector) {
        this.collector = collector;
        this.run();
        return this.transaction.originals().size();
    }

    public boolean reduceScopeForLimitedSpace(long expectedSize) {
        if (this.partialCompactionsAcceptable() && this.transaction.originals().size() > 1) {
            logger.warn("insufficient space to compact all requested files. {}MB required, {}", (Object)Float.valueOf((float)expectedSize / 1024.0f / 1024.0f), (Object)StringUtils.join(this.transaction.originals(), (String)", "));
            SSTableReader removedSSTable = this.cfs.getMaxSizeFile(this.transaction.originals());
            this.transaction.cancel(removedSSTable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runMayThrow() throws Exception {
        assert (this.transaction != null);
        if (this.transaction.originals().isEmpty()) {
            return;
        }
        CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
        if (DatabaseDescriptor.isSnapshotBeforeCompaction()) {
            this.cfs.snapshotWithoutFlush(System.currentTimeMillis() + "-compact-" + this.cfs.name);
        }
        this.checkAvailableDiskSpace();
        assert (!Iterables.any(this.transaction.originals(), new Predicate<SSTableReader>(){

            @Override
            public boolean apply(SSTableReader sstable) {
                return !sstable.descriptor.cfname.equals(CompactionTask.this.cfs.name);
            }
        }));
        UUID taskId = this.transaction.opId();
        StringBuilder ssTableLoggerMsg = new StringBuilder("[");
        for (SSTableReader sstr : this.transaction.originals()) {
            ssTableLoggerMsg.append(String.format("%s:level=%d, ", sstr.getFilename(), sstr.getSSTableLevel()));
        }
        ssTableLoggerMsg.append("]");
        logger.debug("Compacting ({}) {}", (Object)taskId, (Object)ssTableLoggerMsg);
        RateLimiter limiter = CompactionManager.instance.getRateLimiter();
        long start = System.nanoTime();
        long startTime = System.currentTimeMillis();
        long totalKeysWritten = 0L;
        long estimatedKeys = 0L;
        try (CompactionController controller = this.getCompactionController(this.transaction.originals());){
            long totalSourceCQLRows;
            long[] mergedRowCounts;
            Object newSStables;
            long inputSizeBytes;
            Sets.SetView<SSTableReader> actuallyCompact = Sets.difference(this.transaction.originals(), controller.getFullyExpiredSSTables());
            int nowInSec = FBUtilities.nowInSeconds();
            try (Refs<SSTableReader> refs = Refs.ref(actuallyCompact);
                 AbstractCompactionStrategy.ScannerList scanners = strategy.getScanners(actuallyCompact);
                 CompactionIterator ci = new CompactionIterator(this.compactionType, scanners.scanners, controller, nowInSec, taskId);){
                long lastCheckObsoletion = start;
                inputSizeBytes = scanners.getTotalCompressedSize();
                double compressionRatio = scanners.getCompressionRatio();
                if (compressionRatio == -1.0) {
                    compressionRatio = 1.0;
                }
                long lastBytesScanned = 0L;
                if (!controller.cfs.getCompactionStrategyManager().isActive()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                if (this.collector != null) {
                    this.collector.beginCompaction(ci);
                }
                try (CompactionAwareWriter writer = this.getCompactionAwareWriter(this.cfs, this.getDirectories(), this.transaction, actuallyCompact);){
                    estimatedKeys = writer.estimatedKeys();
                    while (ci.hasNext()) {
                        if (ci.isStopRequested()) {
                            throw new CompactionInterruptedException(ci.getCompactionInfo());
                        }
                        if (writer.append(ci.next())) {
                            ++totalKeysWritten;
                        }
                        long bytesScanned = scanners.getTotalBytesScanned();
                        CompactionManager.compactionRateLimiterAcquire(limiter, bytesScanned, lastBytesScanned, compressionRatio);
                        lastBytesScanned = bytesScanned;
                        if (System.nanoTime() - lastCheckObsoletion <= TimeUnit.MINUTES.toNanos(1L)) continue;
                        controller.maybeRefreshOverlaps();
                        lastCheckObsoletion = System.nanoTime();
                    }
                    newSStables = writer.finish();
                }
                finally {
                    if (this.collector != null) {
                        this.collector.finishCompaction(ci);
                    }
                    mergedRowCounts = ci.getMergedRowCounts();
                    totalSourceCQLRows = ci.getTotalSourceCQLRows();
                }
            }
            if (this.transaction.isOffline()) {
                Refs.release(Refs.selfRefs(newSStables));
            } else {
                long durationInNano = System.nanoTime() - start;
                long dTime = TimeUnit.NANOSECONDS.toMillis(durationInNano);
                long startsize = inputSizeBytes;
                long endsize = SSTableReader.getTotalBytes((Iterable<SSTableReader>)newSStables);
                double ratio = (double)endsize / (double)startsize;
                StringBuilder newSSTableNames = new StringBuilder();
                Iterator iterator = newSStables.iterator();
                while (iterator.hasNext()) {
                    SSTableReader reader = (SSTableReader)iterator.next();
                    newSSTableNames.append(reader.descriptor.baseFilename()).append(",");
                }
                long totalSourceRows = 0L;
                for (int i = 0; i < mergedRowCounts.length; ++i) {
                    totalSourceRows += mergedRowCounts[i] * (long)(i + 1);
                }
                String mergeSummary = CompactionTask.updateCompactionHistory(this.cfs.keyspace.getName(), this.cfs.getTableName(), mergedRowCounts, startsize, endsize);
                logger.debug(String.format("Compacted (%s) %d sstables to [%s] to level=%d.  %s to %s (~%d%% of original) in %,dms.  Read Throughput = %s, Write Throughput = %s, Row Throughput = ~%,d/s.  %,d total partitions merged to %,d.  Partition merge counts were {%s}", taskId, this.transaction.originals().size(), newSSTableNames.toString(), this.getLevel(), FBUtilities.prettyPrintMemory(startsize), FBUtilities.prettyPrintMemory(endsize), (int)(ratio * 100.0), dTime, FBUtilities.prettyPrintMemoryPerSecond(startsize, durationInNano), FBUtilities.prettyPrintMemoryPerSecond(endsize, durationInNano), (long)((int)totalSourceCQLRows) / (TimeUnit.NANOSECONDS.toSeconds(durationInNano) + 1L), totalSourceRows, totalKeysWritten, mergeSummary));
                logger.trace("CF Total Bytes Compacted: {}", (Object)FBUtilities.prettyPrintMemory(CompactionTask.addToTotalBytesCompacted(endsize)));
                logger.trace("Actual #keys: {}, Estimated #keys:{}, Err%: {}", new Object[]{totalKeysWritten, estimatedKeys, (double)(totalKeysWritten - estimatedKeys) / (double)totalKeysWritten});
                this.cfs.getCompactionStrategyManager().compactionLogger.compaction(startTime, this.transaction.originals(), System.currentTimeMillis(), (Collection<SSTableReader>)newSStables);
                this.cfs.metric.compactionBytesWritten.inc(endsize);
            }
        }
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction transaction, Set<SSTableReader> nonExpiredSSTables) {
        return new DefaultCompactionWriter(cfs, directories, transaction, nonExpiredSSTables, this.keepOriginals, this.getLevel());
    }

    public static String updateCompactionHistory(String keyspaceName, String columnFamilyName, long[] mergedRowCounts, long startSize, long endSize) {
        StringBuilder mergeSummary = new StringBuilder(mergedRowCounts.length * 10);
        HashMap<Integer, Long> mergedRows = new HashMap<Integer, Long>();
        for (int i = 0; i < mergedRowCounts.length; ++i) {
            long count = mergedRowCounts[i];
            if (count == 0L) continue;
            int rows = i + 1;
            mergeSummary.append(String.format("%d:%d, ", rows, count));
            mergedRows.put(rows, count);
        }
        SystemKeyspace.updateCompactionHistory(keyspaceName, columnFamilyName, System.currentTimeMillis(), startSize, endSize, mergedRows);
        return mergeSummary.toString();
    }

    protected Directories getDirectories() {
        return this.cfs.getDirectories();
    }

    public static long getMinRepairedAt(Set<SSTableReader> actuallyCompact) {
        long minRepairedAt = Long.MAX_VALUE;
        for (SSTableReader sstable : actuallyCompact) {
            minRepairedAt = Math.min(minRepairedAt, sstable.getSSTableMetadata().repairedAt);
        }
        if (minRepairedAt == Long.MAX_VALUE) {
            return 0L;
        }
        return minRepairedAt;
    }

    protected void checkAvailableDiskSpace() {
        if (!this.cfs.isCompactionDiskSpaceCheckEnabled() && this.compactionType == OperationType.COMPACTION) {
            logger.info("Compaction space check is disabled");
            return;
        }
        CompactionStrategyManager strategy = this.cfs.getCompactionStrategyManager();
        while (true) {
            long expectedWriteSize = this.cfs.getExpectedCompactedFileSize(this.transaction.originals(), this.compactionType);
            long estimatedSSTables = Math.max(1L, expectedWriteSize / strategy.getMaxSSTableBytes());
            if (this.cfs.getDirectories().hasAvailableDiskSpace(estimatedSSTables, expectedWriteSize)) break;
            if (!this.reduceScopeForLimitedSpace(expectedWriteSize)) {
                String msg = String.format("Not enough space for compaction, estimated sstables = %d, expected write size = %d", estimatedSSTables, expectedWriteSize);
                logger.warn(msg);
                throw new RuntimeException(msg);
            }
            logger.warn("Not enough space for compaction, {}MB estimated.  Reducing scope.", (Object)Float.valueOf((float)expectedWriteSize / 1024.0f / 1024.0f));
        }
    }

    protected int getLevel() {
        return 0;
    }

    protected CompactionController getCompactionController(Set<SSTableReader> toCompact) {
        return new CompactionController(this.cfs, toCompact, this.gcBefore);
    }

    protected boolean partialCompactionsAcceptable() {
        return !this.isUserDefined;
    }

    public static long getMaxDataAge(Collection<SSTableReader> sstables) {
        long max = 0L;
        for (SSTableReader sstable : sstables) {
            if (sstable.maxDataAge <= max) continue;
            max = sstable.maxDataAge;
        }
        return max;
    }
}

