/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Throwables;
import org.cassandraunit.shaded.com.google.common.base.Predicate;
import org.cassandraunit.shaded.com.google.common.base.Predicates;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableMap;
import org.cassandraunit.shaded.com.google.common.collect.ImmutableSet;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;

class Helpers {
    Helpers() {
    }

    static <T> Set<T> replace(Set<T> original, Set<T> remove2, Iterable<T> add2) {
        return ImmutableSet.copyOf(Helpers.replace(Helpers.identityMap(original), remove2, add2).keySet());
    }

    static <T> Map<T, T> replace(Map<T, T> original, Set<T> remove2, Iterable<T> add2) {
        for (T reader : remove2) {
            assert (original.get(reader) == reader);
        }
        assert (!Iterables.any(add2, Predicates.and(Predicates.not(Predicates.in(remove2)), Predicates.in(original.keySet())))) : String.format("original:%s remove:%s add:%s", original.keySet(), remove2, add2);
        Map<T, T> result = Helpers.identityMap(Iterables.concat(add2, Iterables.filter(original.keySet(), Predicates.not(Predicates.in(remove2)))));
        assert (result.size() == original.size() - remove2.size() + Iterables.size(add2)) : String.format("Expecting new size of %d, got %d while replacing %s by %s in %s", original.size() - remove2.size() + Iterables.size(add2), result.size(), remove2, add2, original.keySet());
        return result;
    }

    static void setupOnline(Iterable<SSTableReader> readers) {
        for (SSTableReader reader : readers) {
            reader.setupOnline();
        }
    }

    static Throwable setReplaced(Iterable<SSTableReader> readers, Throwable accumulate) {
        for (SSTableReader reader : readers) {
            try {
                reader.setReplaced();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    static void checkNotReplaced(Iterable<SSTableReader> readers) {
        for (SSTableReader reader : readers) {
            assert (!reader.isReplaced());
        }
    }

    static Throwable markObsolete(List<LogTransaction.Obsoletion> obsoletions, Throwable accumulate) {
        if (obsoletions == null || obsoletions.isEmpty()) {
            return accumulate;
        }
        for (LogTransaction.Obsoletion obsoletion : obsoletions) {
            try {
                obsoletion.reader.markObsolete(obsoletion.tidier);
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    static Throwable prepareForObsoletion(Iterable<SSTableReader> readers, LogTransaction txnLogs, List<LogTransaction.Obsoletion> obsoletions, Throwable accumulate) {
        for (SSTableReader reader : readers) {
            try {
                obsoletions.add(new LogTransaction.Obsoletion(reader, txnLogs.obsoleted(reader)));
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    static Throwable prepareForBulkObsoletion(Iterable<SSTableReader> readers, LogTransaction txnLogs, List<LogTransaction.Obsoletion> obsoletions, Throwable accumulate) {
        try {
            for (Map.Entry<SSTableReader, LogTransaction.SSTableTidier> entry : txnLogs.bulkObsoletion(readers).entrySet()) {
                obsoletions.add(new LogTransaction.Obsoletion(entry.getKey(), entry.getValue()));
            }
        }
        catch (Throwable t) {
            accumulate = Throwables.merge(accumulate, t);
        }
        return accumulate;
    }

    static Throwable abortObsoletion(List<LogTransaction.Obsoletion> obsoletions, Throwable accumulate) {
        if (obsoletions == null || obsoletions.isEmpty()) {
            return accumulate;
        }
        for (LogTransaction.Obsoletion obsoletion : obsoletions) {
            try {
                obsoletion.tidier.abort();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    static <T> Map<T, T> identityMap(Iterable<T> values) {
        ImmutableMap.Builder<T, T> builder = ImmutableMap.builder();
        for (T t : values) {
            builder.put(t, t);
        }
        return builder.build();
    }

    static <T> Iterable<T> concatUniq(Set<T> ... sets) {
        ArrayList<Predicate<T>> notIn = new ArrayList<Predicate<T>>(sets.length);
        for (Set<T> set : sets) {
            notIn.add(Predicates.not(Predicates.in(set)));
        }
        ArrayList<Iterable<T>> results = new ArrayList<Iterable<T>>(sets.length);
        for (int i = 0; i < sets.length; ++i) {
            results.add(Iterables.filter(sets[i], Predicates.and(notIn.subList(0, i))));
        }
        return Iterables.concat(results);
    }

    static <T> Predicate<T> notIn(Set<T> ... sets) {
        return Predicates.not(Helpers.orIn(sets));
    }

    static <T> Predicate<T> orIn(Collection<T> ... sets) {
        Predicate[] orIn = new Predicate[sets.length];
        for (int i = 0; i < orIn.length; ++i) {
            orIn[i] = Predicates.in(sets[i]);
        }
        return Predicates.or(orIn);
    }

    static <T> Iterable<T> filterOut(Iterable<T> filter, Set<T> ... inNone) {
        return Iterables.filter(filter, Helpers.notIn(inNone));
    }

    static <T> Iterable<T> filterIn(Iterable<T> filter, Set<T> ... inAny) {
        return Iterables.filter(filter, Helpers.orIn(inAny));
    }

    static Set<SSTableReader> emptySet() {
        return Collections.emptySet();
    }

    static <T> T select(T t, Collection<T> col) {
        if (col instanceof Set && !col.contains(t)) {
            return null;
        }
        return Iterables.getFirst(Iterables.filter(col, Predicates.equalTo(t)), null);
    }

    static <T> T selectFirst(T t, Collection<T> ... sets) {
        for (Collection<T> set : sets) {
            T select = Helpers.select(t, set);
            if (select == null) continue;
            return select;
        }
        return null;
    }

    static <T> Predicate<T> idIn(Set<T> set) {
        return Helpers.idIn(Helpers.identityMap(set));
    }

    static <T> Predicate<T> idIn(final Map<T, T> identityMap) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T t) {
                return identityMap.get(t) == t;
            }
        };
    }
}

