/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import java.util.Arrays;
import org.apache.cassandra.db.transform.MoreContents;
import org.apache.cassandra.db.transform.Transformation;

class Stack {
    public static final Transformation[] EMPTY_TRANSFORMATIONS = new Transformation[0];
    public static final MoreContentsHolder[] EMPTY_MORE_CONTENTS_HOLDERS = new MoreContentsHolder[0];
    static final Stack EMPTY = new Stack();
    Transformation[] stack;
    int length;
    MoreContentsHolder[] moreContents;

    Stack() {
        this.stack = EMPTY_TRANSFORMATIONS;
        this.moreContents = EMPTY_MORE_CONTENTS_HOLDERS;
    }

    Stack(Stack copy) {
        this.stack = copy.stack;
        this.length = copy.length;
        this.moreContents = copy.moreContents;
    }

    void add(Transformation add2) {
        if (this.length == this.stack.length) {
            this.stack = Stack.resize(this.stack);
        }
        this.stack[this.length++] = add2;
    }

    void add(MoreContents more) {
        this.moreContents = Arrays.copyOf(this.moreContents, this.moreContents.length + 1);
        this.moreContents[this.moreContents.length - 1] = new MoreContentsHolder(more, this.length);
    }

    private static <E> E[] resize(E[] array) {
        int newLen = array.length == 0 ? 5 : array.length * 2;
        return Arrays.copyOf(array, newLen);
    }

    void refill(Stack prefix, MoreContentsHolder holder, int index) {
        this.moreContents = Stack.splice(prefix.moreContents, prefix.moreContents.length, this.moreContents, index, this.moreContents.length);
        this.stack = Stack.splice(prefix.stack, prefix.length, this.stack, holder.length, this.length);
        this.length += prefix.length - holder.length;
        holder.length = prefix.length;
    }

    private static <E> E[] splice(E[] prefix, int prefixCount, E[] keep, int keepFrom, int keepTo) {
        int keepCount = keepTo - keepFrom;
        int newCount = prefixCount + keepCount;
        if (newCount > keep.length) {
            keep = Arrays.copyOf(keep, newCount);
        }
        if (keepFrom != prefixCount) {
            System.arraycopy(keep, keepFrom, keep, prefixCount, keepCount);
        }
        if (prefixCount != 0) {
            System.arraycopy(prefix, 0, keep, 0, prefixCount);
        }
        return keep;
    }

    static class MoreContentsHolder {
        final MoreContents moreContents;
        int length;

        private MoreContentsHolder(MoreContents moreContents, int length) {
            this.moreContents = moreContents;
            this.length = length;
        }
    }
}

