/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.Views;
import org.cassandraunit.shaded.com.google.common.base.MoreObjects;
import org.cassandraunit.shaded.com.google.common.base.Objects;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;

public final class KeyspaceMetadata {
    public final String name;
    public final KeyspaceParams params;
    public final Tables tables;
    public final Views views;
    public final Types types;
    public final Functions functions;

    private KeyspaceMetadata(String name, KeyspaceParams params, Tables tables, Views views, Types types, Functions functions) {
        this.name = name;
        this.params = params;
        this.tables = tables;
        this.views = views;
        this.types = types;
        this.functions = functions;
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params) {
        return new KeyspaceMetadata(name, params, Tables.none(), Views.none(), Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables) {
        return new KeyspaceMetadata(name, params, tables, Views.none(), Types.none(), Functions.none());
    }

    public static KeyspaceMetadata create(String name, KeyspaceParams params, Tables tables, Views views, Types types, Functions functions) {
        return new KeyspaceMetadata(name, params, tables, views, types, functions);
    }

    public KeyspaceMetadata withSwapped(KeyspaceParams params) {
        return new KeyspaceMetadata(this.name, params, this.tables, this.views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Tables regular) {
        return new KeyspaceMetadata(this.name, this.params, regular, this.views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Views views) {
        return new KeyspaceMetadata(this.name, this.params, this.tables, views, this.types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Types types) {
        return new KeyspaceMetadata(this.name, this.params, this.tables, this.views, types, this.functions);
    }

    public KeyspaceMetadata withSwapped(Functions functions) {
        return new KeyspaceMetadata(this.name, this.params, this.tables, this.views, this.types, functions);
    }

    public Iterable<CFMetaData> tablesAndViews() {
        return Iterables.concat(this.tables, this.views.metadatas());
    }

    @Nullable
    public CFMetaData getTableOrViewNullable(String tableOrViewName) {
        ViewDefinition view = this.views.getNullable(tableOrViewName);
        return view == null ? this.tables.getNullable(tableOrViewName) : view.metadata;
    }

    public Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (CFMetaData table : this.tables) {
            if (cfToExclude != null && table.cfName.equals(cfToExclude)) continue;
            for (IndexMetadata index : table.getIndexes()) {
                indexNames.add(index.name);
            }
        }
        return indexNames;
    }

    public Optional<CFMetaData> findIndexedTable(String indexName) {
        for (CFMetaData cfm : this.tablesAndViews()) {
            if (!cfm.getIndexes().has(indexName)) continue;
            return Optional.of(cfm);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.params, this.tables, this.views, this.functions, this.types);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyspaceMetadata)) {
            return false;
        }
        KeyspaceMetadata other = (KeyspaceMetadata)o;
        return this.name.equals(other.name) && this.params.equals(other.params) && this.tables.equals(other.tables) && this.views.equals(other.views) && this.functions.equals(other.functions) && this.types.equals(other.types);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("params", this.params).add("tables", this.tables).add("views", this.views).add("functions", this.functions).add("types", this.types).toString();
    }

    public void validate() {
        if (!CFMetaData.isNameValid(this.name)) {
            throw new ConfigurationException(String.format("Keyspace name must not be empty, more than %s characters long, or contain non-alphanumeric-underscore characters (got \"%s\")", 48, this.name));
        }
        this.params.validate(this.name);
        this.tablesAndViews().forEach(CFMetaData::validate);
    }
}

