/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.concurrent.ExecutorLocal;
import org.cassandraunit.shaded.io.netty.util.concurrent.FastThreadLocal;

public class ClientWarn
implements ExecutorLocal<State> {
    private static final String TRUNCATED = " [truncated]";
    private static final FastThreadLocal<State> warnLocal = new FastThreadLocal();
    public static ClientWarn instance = new ClientWarn();

    private ClientWarn() {
    }

    @Override
    public State get() {
        return warnLocal.get();
    }

    @Override
    public void set(State value) {
        warnLocal.set(value);
    }

    public void warn(String text) {
        State state = warnLocal.get();
        if (state != null) {
            state.add(text);
        }
    }

    public void captureWarnings() {
        warnLocal.set(new State());
    }

    public List<String> getWarnings() {
        State state = warnLocal.get();
        if (state == null || state.warnings.isEmpty()) {
            return null;
        }
        return state.warnings;
    }

    public void resetWarnings() {
        warnLocal.remove();
    }

    public static class State {
        private final List<String> warnings = new ArrayList<String>();

        private void add(String warning) {
            if (this.warnings.size() < 65535) {
                this.warnings.add(State.maybeTruncate(warning));
            }
        }

        private static String maybeTruncate(String warning) {
            return warning.length() > 65535 ? warning.substring(0, 65535 - ClientWarn.TRUNCATED.length()) + ClientWarn.TRUNCATED : warning;
        }
    }
}

