/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.UUIDSerializer;
import org.cassandraunit.shaded.com.google.common.base.Objects;

public class StreamSummary
implements Serializable {
    public static final IVersionedSerializer<StreamSummary> serializer = new StreamSummarySerializer();
    public final UUID cfId;
    public final int files;
    public final long totalSize;

    public StreamSummary(UUID cfId, int files, long totalSize) {
        this.cfId = cfId;
        this.files = files;
        this.totalSize = totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSummary summary = (StreamSummary)o;
        return this.files == summary.files && this.totalSize == summary.totalSize && this.cfId.equals(summary.cfId);
    }

    public int hashCode() {
        return Objects.hashCode(this.cfId, this.files, this.totalSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StreamSummary{");
        sb.append("path=").append(this.cfId);
        sb.append(", files=").append(this.files);
        sb.append(", totalSize=").append(this.totalSize);
        sb.append('}');
        return sb.toString();
    }

    public static class StreamSummarySerializer
    implements IVersionedSerializer<StreamSummary> {
        @Override
        public void serialize(StreamSummary summary, DataOutputPlus out, int version) throws IOException {
            UUIDSerializer.serializer.serialize(summary.cfId, out, MessagingService.current_version);
            out.writeInt(summary.files);
            out.writeLong(summary.totalSize);
        }

        @Override
        public StreamSummary deserialize(DataInputPlus in, int version) throws IOException {
            UUID cfId = UUIDSerializer.serializer.deserialize(in, MessagingService.current_version);
            int files = in.readInt();
            long totalSize = in.readLong();
            return new StreamSummary(cfId, files, totalSize);
        }

        @Override
        public long serializedSize(StreamSummary summary, int version) {
            long size = UUIDSerializer.serializer.serializedSize(summary.cfId, MessagingService.current_version);
            size += (long)TypeSizes.sizeof(summary.files);
            return size += (long)TypeSizes.sizeof(summary.totalSize);
        }
    }
}

