/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.nodetool.stats.StatsHolder;

public class TpStatsHolder
implements StatsHolder {
    public final NodeProbe probe;

    public TpStatsHolder(NodeProbe probe) {
        this.probe = probe;
    }

    @Override
    public Map<String, Object> convert2Map() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap threadPools = new HashMap();
        HashMap<String, Object> droppedMessage = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : this.probe.getThreadPools().entries()) {
            HashMap<String, Object> threadPool = new HashMap<String, Object>();
            threadPool.put("ActiveTasks", this.probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "ActiveTasks"));
            threadPool.put("PendingTasks", this.probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "PendingTasks"));
            threadPool.put("CompletedTasks", this.probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "CompletedTasks"));
            threadPool.put("CurrentlyBlockedTasks", this.probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "CurrentlyBlockedTasks"));
            threadPool.put("TotalBlockedTasks", this.probe.getThreadPoolMetric(entry.getKey(), entry.getValue(), "TotalBlockedTasks"));
            threadPools.put(entry.getValue(), threadPool);
        }
        result.put("ThreadPools", threadPools);
        for (Map.Entry<String, Object> entry : this.probe.getDroppedMessages().entrySet()) {
            droppedMessage.put(entry.getKey(), entry.getValue());
        }
        result.put("DroppedMessage", droppedMessage);
        return result;
    }
}

