/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport.messages;

import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.ProtocolVersion;
import org.cassandraunit.shaded.io.netty.buffer.ByteBuf;

public class AuthenticateMessage
extends Message.Response {
    public static final Message.Codec<AuthenticateMessage> codec = new Message.Codec<AuthenticateMessage>(){

        @Override
        public AuthenticateMessage decode(ByteBuf body, ProtocolVersion version) {
            String authenticator = CBUtil.readString(body);
            return new AuthenticateMessage(authenticator);
        }

        @Override
        public void encode(AuthenticateMessage msg, ByteBuf dest, ProtocolVersion version) {
            CBUtil.writeString(msg.authenticator, dest);
        }

        @Override
        public int encodedSize(AuthenticateMessage msg, ProtocolVersion version) {
            return CBUtil.sizeOfString(msg.authenticator);
        }
    };
    public final String authenticator;

    public AuthenticateMessage(String authenticator) {
        super(Message.Type.AUTHENTICATE);
        this.authenticator = authenticator;
    }

    public String toString() {
        return "AUTHENTICATE " + this.authenticator;
    }
}

