/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.cassandraunit.shaded.com.google.common.annotations.VisibleForTesting;
import org.cassandraunit.shaded.com.google.common.util.concurrent.RateLimiter;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

@VisibleForTesting
public class TestRateLimiter
extends Helper {
    private static final AtomicReference<RateLimiter> ref = new AtomicReference();

    protected TestRateLimiter(Rule rule) {
        super(rule);
    }

    public void acquire(double rate) {
        RateLimiter limiter = ref.get();
        if (limiter == null || limiter.getRate() != rate) {
            ref.compareAndSet(limiter, RateLimiter.create(rate));
            limiter = ref.get();
        }
        limiter.acquire(1);
    }
}

