/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SelfRefCounted;
import org.cassandraunit.shaded.com.google.common.base.Function;
import org.cassandraunit.shaded.com.google.common.collect.Iterables;
import org.cassandraunit.shaded.com.google.common.collect.Iterators;

public final class Refs<T extends RefCounted<T>>
extends AbstractCollection<T>
implements AutoCloseable {
    private final Map<T, Ref<T>> references;

    public Refs() {
        this.references = new HashMap<T, Ref<T>>();
    }

    public Refs(Map<T, Ref<T>> references) {
        this.references = new HashMap<T, Ref<T>>(references);
    }

    public void release() {
        try {
            Refs.release(this.references.values());
        }
        finally {
            this.references.clear();
        }
    }

    @Override
    public void close() {
        this.release();
    }

    public Ref<T> get(T referenced) {
        return this.references.get(referenced);
    }

    public void release(T referenced) {
        Ref<T> ref = this.references.remove(referenced);
        if (ref == null) {
            throw new IllegalStateException("This Refs collection does not hold a reference to " + referenced);
        }
        ref.release();
    }

    public boolean releaseIfHolds(T referenced) {
        Ref<T> ref = this.references.remove(referenced);
        if (ref != null) {
            ref.release();
        }
        return ref != null;
    }

    public void relaseAllExcept(Collection<T> keep) {
        ArrayList<T> release = new ArrayList<T>(this.references.keySet());
        release.retainAll(keep);
        this.release((Collection<T>)release);
    }

    public void release(Collection<T> release) {
        IllegalStateException notPresentFail;
        block7: {
            ArrayList<Ref<T>> refs = new ArrayList<Ref<T>>();
            ArrayList<RefCounted> notPresent = null;
            for (RefCounted obj : release) {
                Ref<T> ref = this.references.remove(obj);
                if (ref == null) {
                    if (notPresent == null) {
                        notPresent = new ArrayList<RefCounted>();
                    }
                    notPresent.add(obj);
                    continue;
                }
                refs.add(ref);
            }
            notPresentFail = null;
            if (notPresent != null) {
                notPresentFail = new IllegalStateException("Could not release references to " + notPresent + " as references to these objects were not held");
                notPresentFail.fillInStackTrace();
            }
            try {
                Refs.release(refs);
            }
            catch (Throwable t) {
                if (notPresentFail == null) break block7;
                t.addSuppressed(notPresentFail);
            }
        }
        if (notPresentFail != null) {
            throw notPresentFail;
        }
    }

    public boolean tryRef(T t) {
        Ref ref = t.tryRef();
        if (ref == null) {
            return false;
        }
        if ((ref = this.references.put(t, ref)) != null) {
            ref.release();
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.unmodifiableIterator(this.references.keySet().iterator());
    }

    @Override
    public int size() {
        return this.references.size();
    }

    public Refs<T> addAll(Refs<T> add2) {
        ArrayList<Ref<T>> overlap = new ArrayList<Ref<T>>();
        for (Map.Entry<T, Ref<T>> e : add2.references.entrySet()) {
            if (this.references.containsKey(e.getKey())) {
                overlap.add(e.getValue());
                continue;
            }
            this.references.put(e.getKey(), e.getValue());
        }
        add2.references.clear();
        Refs.release(overlap);
        return this;
    }

    public static <T extends RefCounted<T>> Refs<T> tryRef(Iterable<T> reference) {
        HashMap refs = new HashMap();
        for (RefCounted rc : reference) {
            Ref ref = rc.tryRef();
            if (ref == null) {
                Refs.release(refs.values());
                return null;
            }
            refs.put(rc, ref);
        }
        return new Refs(refs);
    }

    public static <T extends RefCounted<T>> Refs<T> ref(Iterable<T> reference) {
        Refs<T> refs = Refs.tryRef(reference);
        if (refs != null) {
            return refs;
        }
        throw new IllegalStateException();
    }

    public static void release(Iterable<? extends Ref<?>> refs) {
        Throwables.maybeFail(Refs.release(refs, null));
    }

    public static Throwable release(Iterable<? extends Ref<?>> refs, Throwable accumulate) {
        for (Ref<?> ref : refs) {
            try {
                ref.release();
            }
            catch (Throwable t) {
                accumulate = Throwables.merge(accumulate, t);
            }
        }
        return accumulate;
    }

    public static <T extends SelfRefCounted<T>> Iterable<Ref<T>> selfRefs(Iterable<T> refs) {
        return Iterables.transform(refs, new Function<T, Ref<T>>(){

            @Override
            @Nullable
            public Ref<T> apply(T t) {
                return t.selfRef();
            }
        });
    }
}

