/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.shaded.com.addthis.metrics3.reporter.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import java.net.InetSocketAddress;
import java.util.List;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.AbstractGraphiteReporterConfig;
import org.cassandraunit.shaded.com.addthis.metrics.reporter.config.HostPort;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricFilterTransformer;
import org.cassandraunit.shaded.com.addthis.metrics3.reporter.config.MetricsReporterConfigThree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporterConfig
extends AbstractGraphiteReporterConfig
implements MetricsReporterConfigThree {
    private static final Logger log = LoggerFactory.getLogger(GraphiteReporterConfig.class);
    private GraphiteReporter reporter;

    private void enableMetrics3(HostPort hostPort, MetricRegistry registry) {
        this.reporter = GraphiteReporter.forRegistry((MetricRegistry)registry).convertRatesTo(this.getRealRateunit()).convertDurationsTo(this.getRealDurationunit()).prefixedWith(this.getResolvedPrefix()).filter(MetricFilterTransformer.generateFilter(this.getPredicate())).build((GraphiteSender)new Graphite(new InetSocketAddress(hostPort.getHost(), hostPort.getPort())));
        this.reporter.start(this.getPeriod(), this.getRealTimeunit());
    }

    @Override
    public void report() {
        if (this.reporter != null) {
            this.reporter.report();
        }
    }

    @Override
    public boolean enable(MetricRegistry registry) {
        boolean success = this.setup("com.codahale.metrics.graphite.GraphiteReporter");
        if (!success) {
            return false;
        }
        List<HostPort> hosts = this.getFullHostList();
        for (HostPort hostPort : hosts) {
            log.info("Enabling GraphiteReporter to {}:{}", new Object[]{hostPort.getHost(), hostPort.getPort()});
            try {
                this.enableMetrics3(hostPort, registry);
            }
            catch (Exception e) {
                log.error("Failed to enable GraphiteReporter", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

